/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.ignite.IgniteCacheOptions;
import io.vertx.spi.cluster.ignite.IgniteDiscoveryOptions;
import io.vertx.spi.cluster.ignite.IgniteMetricExporterOptions;
import io.vertx.spi.cluster.ignite.IgniteOptions;
import io.vertx.spi.cluster.ignite.IgniteSslOptions;
import io.vertx.spi.cluster.ignite.util.ConfigHelper;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.noop.NoopMetricExporterSpi;
import org.junit.Assert;
import org.junit.Test;

public class IgniteOptionsTest {
    private static final String IGNITE_JSON = "{\n  \"connectTimeout\": 2000,\n  \"connectionsPerNode\": 2,\n  \"idleConnectionTimeout\": 300000,\n  \"localHost\": \"localHost\",\n  \"localPort\": 12345,\n  \"maxConnectTimeout\": 200000,\n  \"metricsLogFrequency\": 10,\n  \"reconnectCount\": 20,\n  \"shutdownOnSegmentation\": true,\n  \"shutdownOnNodeStop\": false, \n  \"delayAfterStart\": 100, \n  \"discoverySpi\": {\n    \"type\": \"TcpDiscoveryVmIpFinder\",\n    \"properties\": {\n      \"joinTimeout\": 10000\n    }\n  },\n  \"cacheConfiguration\": [{\n    \"name\": \"*\",\n    \"atomicityMode\": \"TRANSACTIONAL\",\n    \"backups\": 1,\n    \"cacheMode\": \"PARTITIONED\",\n    \"copyOnRead\": false,\n    \"defaultLockTimeout\": 1000,\n    \"eagerTtl\": false,\n    \"encryptionEnabled\": false,\n    \"eventsDisabled\": true,\n    \"groupName\": \"testGroup\",\n    \"invalidate\": true,\n    \"maxConcurrentAsyncOperations\": 100,\n    \"maxQueryInteratorsCount\": 512,\n    \"onheapCacheEnabled\": true,\n    \"partitionLossPolicy\": \"READ_WRITE_ALL\",\n    \"readFromBackup\": false,\n    \"rebalanceDelay\": 100,\n    \"rebalanceMode\": \"SYNC\",\n    \"rebalanceOrder\": 1,\n    \"writeSynchronizationMode\": \"FULL_SYNC\",\n    \"metricsEnabled\": true,\n    \"expiryPolicy\": {\n      \"type\": \"created\",\n      \"duration\": 60000\n    }\n  }],\n  \"sslContextFactory\": {\n    \"keyAlgorithm\": \"SunX509\",\n    \"keyStoreFilePath\": \"src/test/resources/server.jks\",\n    \"keyStorePassword\": \"123456\",\n    \"keyStoreType\": \"JKS\",\n    \"protocol\": \"TLSv1.2\",\n    \"trustAll\": true,\n    \"trustStoreFilePath\": \"src/test/resources/server.jks\",\n    \"trustStorePassword\": \"123456\",\n    \"trustStoreType\": \"JKS\"\n  },\n  \"pageSize\": 1024,\n  \"defaultRegionInitialSize\": 41943040,\n  \"defaultRegionMaxSize\": 104857600,\n  \"defaultRegionMetricsEnabled\": true,\n  \"metricsUpdateFrequency\": 100000,\n  \"clientFailureDetectionTimeout\": 200000,\n  \"metricsHistorySize\": 1,\n  \"metricsExpireTime\": 2,\n  \"systemViewExporterSpiDisabled\": true\n}";
    private static final String IGNITE_JSON_PEM_CERT = "{\n  \"sslContextFactory\": {\n    \"protocol\": \"TLSv1.2\",\n    \"pemKeyCertOptions\": {\n      \"keyPath\": \"src/test/resources/server-key.pem\",\n      \"certPath\": \"src/test/resources/server-cert.pem\"\n    },\n    \"pemTrustOptions\": {\n      \"certPaths\": [\"src/test/resources/ca.pem\"]\n    }\n  }\n}";
    private static final String IGNITE_JSON_PFX_CERT = "{\n  \"sslContextFactory\": {\n    \"protocol\": \"TLSv1.2\",\n    \"pfxKeyCertOptions\": {\n      \"path\": \"src/test/resources/server-keystore.p12\",\n      \"password\": \"wibble\"\n    },\n    \"pfxTrustOptions\": {\n      \"path\": \"src/test/resources/ca.p12\",\n      \"password\": \"wibble\"\n    }\n  }\n}";
    private static final String IGNITE_JSON_JKS_CERT = "{\n  \"sslContextFactory\": {\n    \"protocol\": \"TLSv1.2\",\n    \"jksKeyCertOptions\": {\n      \"path\": \"src/test/resources/server.jks\",\n      \"password\": \"123456\"\n    },\n    \"jksTrustOptions\": {\n      \"path\": \"src/test/resources/server.jks\",\n      \"password\": \"123456\"\n    }\n  }\n}";

    @Test
    public void defaults() {
        IgniteOptions options = new IgniteOptions();
        Assert.assertNull((Object)options.getLocalHost());
        Assert.assertEquals((long)47100L, (long)options.getLocalPort());
        Assert.assertEquals((long)1L, (long)options.getConnectionsPerNode());
        Assert.assertEquals((long)5000L, (long)options.getConnectTimeout());
        Assert.assertEquals((long)600000L, (long)options.getIdleConnectionTimeout());
        Assert.assertEquals((long)10L, (long)options.getReconnectCount());
        Assert.assertEquals((long)600000L, (long)options.getMaxConnectTimeout());
        Assert.assertEquals((long)60000L, (long)options.getMetricsLogFrequency());
        Assert.assertEquals((Object)"TcpDiscoveryMulticastIpFinder", (Object)options.getDiscoverySpi().getType());
        Assert.assertEquals((long)0L, (long)options.getDiscoverySpi().getProperties().size());
        Assert.assertNull((Object)options.getDiscoverySpi().getCustomSpi());
        Assert.assertEquals((long)0L, (long)options.getCacheConfiguration().size());
        Assert.assertNull((Object)options.getSslContextFactory());
        Assert.assertTrue((boolean)options.isShutdownOnSegmentation());
        Assert.assertEquals((long)4096L, (long)options.getPageSize());
        Assert.assertEquals((long)0x10000000L, (long)options.getDefaultRegionInitialSize());
        Assert.assertEquals((long)DataStorageConfiguration.DFLT_DATA_REGION_MAX_SIZE, (long)options.getDefaultRegionMaxSize());
        Assert.assertFalse((boolean)options.isDefaultRegionMetricsEnabled());
        Assert.assertFalse((boolean)options.isShutdownOnNodeStop());
        Assert.assertEquals((long)100L, (long)options.getDelayAfterStart());
        Assert.assertEquals((long)2000L, (long)options.getMetricsUpdateFrequency());
        Assert.assertEquals((long)IgniteConfiguration.DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT, (long)options.getClientFailureDetectionTimeout());
        Assert.assertEquals((long)10000L, (long)options.getMetricsHistorySize());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)options.getMetricsExpireTime());
        Assert.assertNotNull((Object)options.getMetricExporterSpi());
    }

    @Test
    public void fromEmptyJson() {
        IgniteOptions options = new IgniteOptions(new JsonObject());
        Assert.assertNull((Object)options.getLocalHost());
        Assert.assertEquals((long)47100L, (long)options.getLocalPort());
        Assert.assertEquals((long)1L, (long)options.getConnectionsPerNode());
        Assert.assertEquals((long)5000L, (long)options.getConnectTimeout());
        Assert.assertEquals((long)600000L, (long)options.getIdleConnectionTimeout());
        Assert.assertEquals((long)10L, (long)options.getReconnectCount());
        Assert.assertEquals((long)600000L, (long)options.getMaxConnectTimeout());
        Assert.assertEquals((long)60000L, (long)options.getMetricsLogFrequency());
        Assert.assertEquals((Object)"TcpDiscoveryMulticastIpFinder", (Object)options.getDiscoverySpi().getType());
        Assert.assertEquals((long)0L, (long)options.getDiscoverySpi().getProperties().size());
        Assert.assertNull((Object)options.getDiscoverySpi().getCustomSpi());
        Assert.assertEquals((long)0L, (long)options.getCacheConfiguration().size());
        Assert.assertNull((Object)options.getSslContextFactory());
        Assert.assertTrue((boolean)options.isShutdownOnSegmentation());
        Assert.assertEquals((long)4096L, (long)options.getPageSize());
        Assert.assertEquals((long)0x10000000L, (long)options.getDefaultRegionInitialSize());
        Assert.assertEquals((long)DataStorageConfiguration.DFLT_DATA_REGION_MAX_SIZE, (long)options.getDefaultRegionMaxSize());
        Assert.assertFalse((boolean)options.isDefaultRegionMetricsEnabled());
        Assert.assertFalse((boolean)options.isShutdownOnNodeStop());
        Assert.assertEquals((long)100L, (long)options.getDelayAfterStart());
        Assert.assertEquals((long)2000L, (long)options.getMetricsUpdateFrequency());
        Assert.assertEquals((long)IgniteConfiguration.DFLT_CLIENT_FAILURE_DETECTION_TIMEOUT, (long)options.getClientFailureDetectionTimeout());
        Assert.assertEquals((long)10000L, (long)options.getMetricsHistorySize());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)options.getMetricsExpireTime());
        Assert.assertNotNull((Object)options.getMetricExporterSpi());
    }

    private void checkConfig(IgniteOptions options, IgniteConfiguration config) {
        Assert.assertEquals((Object)options.getLocalHost(), (Object)config.getLocalHost());
        Assert.assertEquals((Object)"TcpCommunicationSpi", (Object)config.getCommunicationSpi().getClass().getSimpleName());
        Assert.assertEquals((long)options.getLocalPort(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getLocalPort());
        Assert.assertEquals((long)options.getConnectionsPerNode(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getConnectionsPerNode());
        Assert.assertEquals((long)options.getConnectTimeout(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getConnectTimeout());
        Assert.assertEquals((long)options.getIdleConnectionTimeout(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getIdleConnectionTimeout());
        Assert.assertEquals((long)options.getMaxConnectTimeout(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getMaxConnectTimeout());
        Assert.assertEquals((long)options.getReconnectCount(), (long)((TcpCommunicationSpi)config.getCommunicationSpi()).getReconnectCount());
        Assert.assertEquals((long)options.getMetricsLogFrequency(), (long)config.getMetricsLogFrequency());
        Assert.assertEquals((Object)"TcpDiscoverySpi", (Object)config.getDiscoverySpi().getName());
        Assert.assertEquals((long)options.getDiscoverySpi().getProperties().getLong("joinTimeout"), (long)((TcpDiscoverySpi)config.getDiscoverySpi()).getJoinTimeout());
        Assert.assertEquals((Object)options.getDiscoverySpi().getType(), (Object)((TcpDiscoverySpi)config.getDiscoverySpi()).getIpFinder().getClass().getSimpleName());
        Assert.assertEquals((Object)options.getSslContextFactory().getProtocol(), (Object)((SSLContext)config.getSslContextFactory().create()).getProtocol());
        Assert.assertEquals((long)1L, (long)config.getCacheConfiguration().length);
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getName(), (Object)config.getCacheConfiguration()[0].getName());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getAtomicityMode(), (Object)config.getCacheConfiguration()[0].getAtomicityMode().name());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getCacheMode(), (Object)config.getCacheConfiguration()[0].getCacheMode().name());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getGroupName(), (Object)config.getCacheConfiguration()[0].getGroupName());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getPartitionLossPolicy(), (Object)config.getCacheConfiguration()[0].getPartitionLossPolicy().name());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceMode(), (Object)config.getCacheConfiguration()[0].getRebalanceMode().name());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceDelay(), (long)config.getCacheConfiguration()[0].getRebalanceDelay());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceOrder(), (long)config.getCacheConfiguration()[0].getRebalanceOrder());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getWriteSynchronizationMode(), (Object)config.getCacheConfiguration()[0].getWriteSynchronizationMode().name());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getBackups(), (long)config.getCacheConfiguration()[0].getBackups());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getMaxConcurrentAsyncOperations(), (long)config.getCacheConfiguration()[0].getMaxConcurrentAsyncOperations());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getMaxQueryInteratorsCount(), (long)config.getCacheConfiguration()[0].getMaxQueryIteratorsCount());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isEagerTtl(), (Object)config.getCacheConfiguration()[0].isEagerTtl());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isCopyOnRead(), (Object)config.getCacheConfiguration()[0].isCopyOnRead());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isEventsDisabled(), (Object)config.getCacheConfiguration()[0].isEventsDisabled());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isInvalidate(), (Object)config.getCacheConfiguration()[0].isInvalidate());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isOnheapCacheEnabled(), (Object)config.getCacheConfiguration()[0].isOnheapCacheEnabled());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isReadFromBackup(), (Object)config.getCacheConfiguration()[0].isReadFromBackup());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isMetricsEnabled(), (Object)config.getCacheConfiguration()[0].isStatisticsEnabled());
        Assert.assertNotNull((Object)config.getCacheConfiguration()[0].getExpiryPolicyFactory());
        Assert.assertEquals((long)options.getPageSize(), (long)config.getDataStorageConfiguration().getPageSize());
        Assert.assertEquals((long)options.getDefaultRegionInitialSize(), (long)config.getDataStorageConfiguration().getDefaultDataRegionConfiguration().getInitialSize());
        Assert.assertEquals((long)options.getDefaultRegionMaxSize(), (long)config.getDataStorageConfiguration().getDefaultDataRegionConfiguration().getMaxSize());
        Assert.assertEquals((Object)options.isDefaultRegionMetricsEnabled(), (Object)config.getDataStorageConfiguration().getDefaultDataRegionConfiguration().isMetricsEnabled());
        Assert.assertEquals((long)options.getMetricsUpdateFrequency(), (long)config.getMetricsUpdateFrequency());
        Assert.assertEquals((long)options.getClientFailureDetectionTimeout(), (long)config.getClientFailureDetectionTimeout());
        Assert.assertEquals((long)options.getMetricsHistorySize(), (long)config.getMetricsHistorySize());
        Assert.assertEquals((long)options.getMetricsExpireTime(), (long)config.getMetricsExpireTime());
    }

    private IgniteOptions createIgniteOptions() {
        return new IgniteOptions().setLocalHost("localHost").setLocalPort(12345).setConnectionsPerNode(2).setConnectTimeout(2000L).setIdleConnectionTimeout(300000L).setMaxConnectTimeout(200000L).setReconnectCount(20).setMetricsLogFrequency(10L).setDiscoverySpi(new IgniteDiscoveryOptions().setType("TcpDiscoveryVmIpFinder").setProperties(new JsonObject().put("joinTimeout", (Object)10000L))).setSslContextFactory(new IgniteSslOptions().setProtocol("TLSv1.2").setKeyAlgorithm("SunX509").setKeyStoreType("JKS").setKeyStoreFilePath("src/test/resources/server.jks").setKeyStorePassword("123456").setTrustStoreType("JKS").setTrustStoreFilePath("src/test/resources/server.jks").setTrustStorePassword("123456").setTrustAll(true)).setCacheConfiguration(Collections.singletonList(new IgniteCacheOptions().setName("*").setAtomicityMode("TRANSACTIONAL").setBackups(1).setCacheMode("PARTITIONED").setCopyOnRead(false).setEagerTtl(false).setEventsDisabled(true).setGroupName("testGroup").setInvalidate(true).setMaxConcurrentAsyncOperations(100).setMaxQueryInteratorsCount(512).setOnheapCacheEnabled(true).setPartitionLossPolicy("READ_WRITE_ALL").setReadFromBackup(false).setRebalanceDelay(100L).setRebalanceMode("SYNC").setRebalanceOrder(1).setWriteSynchronizationMode("FULL_SYNC").setExpiryPolicy(new JsonObject().put("type", (Object)"created").put("duration", (Object)60000L)).setMetricsEnabled(true))).setPageSize(1024).setDefaultRegionInitialSize(0x2800000L).setDefaultRegionMaxSize(0x6400000L).setDefaultRegionMetricsEnabled(true).setShutdownOnSegmentation(false).setShutdownOnNodeStop(true).setDelayAfterStart(200L).setMetricsUpdateFrequency(10000L).setClientFailureDetectionTimeout(15000L).setMetricsHistorySize(1).setMetricsExpireTime(2L).setMetricExporterSpi(new IgniteMetricExporterOptions());
    }

    @Test
    public void toConfig() {
        IgniteOptions options = this.createIgniteOptions();
        IgniteConfiguration config = ConfigHelper.toIgniteConfig((Vertx)Vertx.vertx(), (IgniteOptions)options);
        this.checkConfig(options, config);
    }

    @Test(expected=VertxException.class)
    public void noDiscoverySpiFound() {
        IgniteOptions options = new IgniteOptions().setDiscoverySpi(new IgniteDiscoveryOptions().setType("NotExistingSpi"));
        ConfigHelper.toIgniteConfig((Vertx)Vertx.vertx(), (IgniteOptions)options);
    }

    private void checkJson(IgniteOptions options, JsonObject json) {
        Assert.assertEquals((Object)options.getLocalHost(), (Object)json.getString("localHost"));
        Assert.assertEquals((long)options.getLocalPort(), (long)json.getInteger("localPort").intValue());
        Assert.assertEquals((long)options.getConnectionsPerNode(), (long)json.getInteger("connectionsPerNode").intValue());
        Assert.assertEquals((long)options.getConnectTimeout(), (long)json.getLong("connectTimeout"));
        Assert.assertEquals((long)options.getIdleConnectionTimeout(), (long)json.getLong("idleConnectionTimeout"));
        Assert.assertEquals((long)options.getMaxConnectTimeout(), (long)json.getLong("maxConnectTimeout"));
        Assert.assertEquals((long)options.getReconnectCount(), (long)json.getInteger("reconnectCount").intValue());
        Assert.assertEquals((long)options.getMetricsLogFrequency(), (long)json.getLong("metricsLogFrequency"));
        Assert.assertEquals((Object)options.isShutdownOnSegmentation(), (Object)json.getBoolean("shutdownOnSegmentation"));
        Assert.assertEquals((Object)options.isShutdownOnNodeStop(), (Object)json.getBoolean("shutdownOnNodeStop"));
        Assert.assertEquals((long)options.getDelayAfterStart(), (long)json.getLong("delayAfterStart"));
        Assert.assertEquals((Object)options.getDiscoverySpi().getType(), (Object)json.getJsonObject("discoverySpi").getString("type"));
        Assert.assertEquals((Object)options.getDiscoverySpi().getProperties().getLong("joinTimeout"), (Object)json.getJsonObject("discoverySpi").getJsonObject("properties").getLong("joinTimeout"));
        Assert.assertEquals((Object)options.getSslContextFactory().getProtocol(), (Object)json.getJsonObject("sslContextFactory").getString("protocol"));
        Assert.assertEquals((Object)options.getSslContextFactory().getKeyAlgorithm(), (Object)json.getJsonObject("sslContextFactory").getString("keyAlgorithm"));
        Assert.assertEquals((Object)options.getSslContextFactory().getKeyStoreType(), (Object)json.getJsonObject("sslContextFactory").getString("keyStoreType"));
        Assert.assertEquals((Object)options.getSslContextFactory().getKeyStoreFilePath(), (Object)json.getJsonObject("sslContextFactory").getString("keyStoreFilePath"));
        Assert.assertEquals((Object)options.getSslContextFactory().getKeyStorePassword(), (Object)json.getJsonObject("sslContextFactory").getString("keyStorePassword"));
        Assert.assertEquals((Object)options.getSslContextFactory().getTrustStoreType(), (Object)json.getJsonObject("sslContextFactory").getString("trustStoreType"));
        Assert.assertEquals((Object)options.getSslContextFactory().getTrustStoreFilePath(), (Object)json.getJsonObject("sslContextFactory").getString("trustStoreFilePath"));
        Assert.assertEquals((Object)options.getSslContextFactory().getTrustStorePassword(), (Object)json.getJsonObject("sslContextFactory").getString("trustStorePassword"));
        Assert.assertEquals((Object)options.getSslContextFactory().isTrustAll(), (Object)json.getJsonObject("sslContextFactory").getBoolean("trustAll"));
        Assert.assertEquals((long)1L, (long)json.getJsonArray("cacheConfiguration").size());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getName(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("name"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getAtomicityMode(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("atomicityMode"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getCacheMode(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("cacheMode"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getGroupName(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("groupName"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getPartitionLossPolicy(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("partitionLossPolicy"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceMode(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("rebalanceMode"));
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceDelay(), (long)json.getJsonArray("cacheConfiguration").getJsonObject(0).getLong("rebalanceDelay"));
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getRebalanceOrder(), (long)json.getJsonArray("cacheConfiguration").getJsonObject(0).getInteger("rebalanceOrder").intValue());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getWriteSynchronizationMode(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getString("writeSynchronizationMode"));
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getBackups(), (long)json.getJsonArray("cacheConfiguration").getJsonObject(0).getInteger("backups").intValue());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getMaxConcurrentAsyncOperations(), (long)json.getJsonArray("cacheConfiguration").getJsonObject(0).getInteger("maxConcurrentAsyncOperations").intValue());
        Assert.assertEquals((long)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getMaxQueryInteratorsCount(), (long)json.getJsonArray("cacheConfiguration").getJsonObject(0).getInteger("maxQueryInteratorsCount").intValue());
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isEagerTtl(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("eagerTtl"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isCopyOnRead(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("copyOnRead"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isEventsDisabled(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("eventsDisabled"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isInvalidate(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("invalidate"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isOnheapCacheEnabled(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("onheapCacheEnabled"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isReadFromBackup(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("readFromBackup"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getExpiryPolicy().getString("type"), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getJsonObject("expiryPolicy").getString("type"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).getExpiryPolicy().getString("duration"), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getJsonObject("expiryPolicy").getString("duration"));
        Assert.assertEquals((Object)((IgniteCacheOptions)options.getCacheConfiguration().get(0)).isMetricsEnabled(), (Object)json.getJsonArray("cacheConfiguration").getJsonObject(0).getBoolean("metricsEnabled"));
        Assert.assertEquals((long)options.getPageSize(), (long)json.getInteger("pageSize").intValue());
        Assert.assertEquals((long)options.getDefaultRegionInitialSize(), (long)json.getLong("defaultRegionInitialSize"));
        Assert.assertEquals((long)options.getDefaultRegionMaxSize(), (long)json.getLong("defaultRegionMaxSize"));
        Assert.assertEquals((Object)options.isDefaultRegionMetricsEnabled(), (Object)json.getBoolean("defaultRegionMetricsEnabled"));
        Assert.assertEquals((long)options.getMetricsUpdateFrequency(), (long)json.getLong("metricsUpdateFrequency"));
        Assert.assertEquals((long)options.getClientFailureDetectionTimeout(), (long)json.getLong("clientFailureDetectionTimeout"));
        Assert.assertEquals((long)options.getMetricsHistorySize(), (long)json.getInteger("metricsHistorySize").intValue());
        Assert.assertEquals((long)options.getMetricsExpireTime(), (long)json.getLong("metricsExpireTime"));
    }

    @Test
    public void toJson() {
        IgniteOptions options = this.createIgniteOptions();
        JsonObject json = options.toJson();
        this.checkJson(options, json);
    }

    @Test
    public void fromJson() {
        JsonObject json = new JsonObject(IGNITE_JSON);
        IgniteOptions options = new IgniteOptions(json);
        this.checkJson(options, json);
    }

    @Test
    public void copy() {
        IgniteOptions options = this.createIgniteOptions();
        IgniteOptions copy = new IgniteOptions(options);
        Assert.assertEquals((Object)options.getLocalHost(), (Object)copy.getLocalHost());
    }

    @Test
    public void testPemKeyCert() {
        JsonObject json = new JsonObject(IGNITE_JSON_PEM_CERT);
        IgniteSslOptions options = new IgniteOptions(json).getSslContextFactory();
        Assert.assertEquals((Object)options.getPemKeyCertOptions().getKeyPath(), (Object)"src/test/resources/server-key.pem");
        Assert.assertEquals((Object)options.getPemKeyCertOptions().getCertPath(), (Object)"src/test/resources/server-cert.pem");
        Assert.assertEquals(options.getPemTrustOptions().getCertPaths().get(0), (Object)"src/test/resources/ca.pem");
        Assert.assertEquals((Object)((SSLContext)ConfigHelper.toSslContextFactoryConfig((Vertx)Vertx.vertx(), (IgniteSslOptions)options).create()).getProtocol(), (Object)"TLSv1.2");
    }

    @Test
    public void testPfxKeyCert() {
        JsonObject json = new JsonObject(IGNITE_JSON_PFX_CERT);
        IgniteSslOptions options = new IgniteOptions(json).getSslContextFactory();
        Assert.assertEquals((Object)options.getPfxKeyCertOptions().getPath(), (Object)"src/test/resources/server-keystore.p12");
        Assert.assertEquals((Object)options.getPfxKeyCertOptions().getPassword(), (Object)"wibble");
        Assert.assertEquals((Object)options.getPfxTrustOptions().getPath(), (Object)"src/test/resources/ca.p12");
        Assert.assertEquals((Object)options.getPfxTrustOptions().getPassword(), (Object)"wibble");
        Assert.assertEquals((Object)((SSLContext)ConfigHelper.toSslContextFactoryConfig((Vertx)Vertx.vertx(), (IgniteSslOptions)options).create()).getProtocol(), (Object)"TLSv1.2");
    }

    @Test
    public void testJksKeyCert() {
        JsonObject json = new JsonObject(IGNITE_JSON_JKS_CERT);
        IgniteSslOptions options = new IgniteOptions(json).getSslContextFactory();
        Assert.assertEquals((Object)options.getJksKeyCertOptions().getPath(), (Object)"src/test/resources/server.jks");
        Assert.assertEquals((Object)options.getJksKeyCertOptions().getPassword(), (Object)"123456");
        Assert.assertEquals((Object)options.getJksTrustOptions().getPath(), (Object)"src/test/resources/server.jks");
        Assert.assertEquals((Object)options.getJksTrustOptions().getPassword(), (Object)"123456");
        Assert.assertEquals((Object)((SSLContext)ConfigHelper.toSslContextFactoryConfig((Vertx)Vertx.vertx(), (IgniteSslOptions)options).create()).getProtocol(), (Object)"TLSv1.2");
    }

    @Test
    public void testCustomDiscoverySpi() {
        TcpDiscoverySpi customSpi = new TcpDiscoverySpi();
        IgniteOptions options = new IgniteOptions();
        options.getDiscoverySpi().setCustomSpi((DiscoverySpi)customSpi);
        Assert.assertEquals((Object)options.getDiscoverySpi().getProperties(), (Object)new JsonObject());
        Assert.assertEquals((Object)options.getDiscoverySpi().getType(), (Object)"TcpDiscoveryMulticastIpFinder");
        Assert.assertEquals((Object)options.getDiscoverySpi().getCustomSpi(), (Object)customSpi);
        IgniteConfiguration cfg = ConfigHelper.toIgniteConfig((Vertx)Vertx.vertx(), (IgniteOptions)options);
        Assert.assertEquals((Object)cfg.getDiscoverySpi(), (Object)customSpi);
    }

    @Test
    public void testCustomMetricExporterSpi() {
        NoopMetricExporterSpi customSpi = new NoopMetricExporterSpi();
        IgniteOptions options = new IgniteOptions();
        options.getMetricExporterSpi().setCustomSpi((MetricExporterSpi)customSpi);
        IgniteConfiguration cfg = ConfigHelper.toIgniteConfig((Vertx)Vertx.vertx(), (IgniteOptions)options);
        Assert.assertEquals((Object)customSpi, (Object)cfg.getMetricExporterSpi()[0]);
    }
}

