/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.Promise;
import io.vertx.core.impl.VertxInternal;
import io.vertx.spi.cluster.ignite.impl.Throttling;
import io.vertx.test.core.VertxTestBase;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class ThrottlingTest
extends VertxTestBase {
    int threadCount = 4;
    ExecutorService executorService;

    public void setUp() throws Exception {
        super.setUp();
        this.executorService = Executors.newFixedThreadPool(this.threadCount);
    }

    @Test
    public void testInterval() throws Exception {
        int duration = 5;
        String[] addresses = new String[]{"foo", "bar", "baz", "qux"};
        ConcurrentHashMap events = new ConcurrentHashMap(addresses.length);
        Throttling throttling = new Throttling((VertxInternal)this.vertx, address -> {
            events.compute(address, (k, v) -> {
                if (v == null) {
                    v = Collections.synchronizedList(new LinkedList());
                }
                v.add(System.nanoTime());
                return v;
            });
            Promise promise = Promise.promise();
            this.vertx.setTimer(1L, l -> promise.complete());
            return promise.future();
        });
        CountDownLatch latch = new CountDownLatch(this.threadCount);
        long start = System.nanoTime();
        for (int i = 0; i < this.threadCount; ++i) {
            this.executorService.submit(() -> {
                try {
                    do {
                        this.sleepMax(5L);
                        throttling.onEvent(addresses[ThreadLocalRandom.current().nextInt(addresses.length)]);
                    } while (TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS) < (long)duration);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        ThrottlingTest.assertWaitUntil(() -> {
            if (events.size() != addresses.length) {
                return false;
            }
            for (List nanoTimes : events.values()) {
                Long previous = null;
                for (Long nanoTime : nanoTimes) {
                    if (previous != null && TimeUnit.MILLISECONDS.convert(nanoTime - previous, TimeUnit.NANOSECONDS) < 20L) {
                        return false;
                    }
                    previous = nanoTime;
                }
            }
            return true;
        }, (long)1000L);
    }

    private void sleepMax(long time) {
        try {
            TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextLong(time));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void tearDown() throws Exception {
        this.executorService.shutdown();
        this.assertTrue(this.executorService.awaitTermination(5L, TimeUnit.SECONDS));
        super.tearDown();
    }
}

