/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.util;

import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.spi.cluster.ignite.util.ConfigHelper;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class ClasspathHelperTest {
    @Test
    public void loadXml() {
        IgniteConfiguration config = ConfigHelper.lookupXmlConfiguration(this.getClass(), (String[])new String[]{"ignite-test.xml"});
        Assert.assertNotNull((Object)config);
    }

    @Test(expected=VertxException.class)
    public void loadNotExistingXml() {
        ConfigHelper.lookupXmlConfiguration(this.getClass(), (String[])new String[]{"does-not-exist.xml"});
    }

    @Test
    public void loadJson() {
        JsonObject config = ConfigHelper.lookupJsonConfiguration(this.getClass(), (String[])new String[]{"ignite.json"});
        Assert.assertNotNull((Object)config);
        Assert.assertFalse((boolean)config.isEmpty());
    }

    @Test(expected=VertxException.class)
    public void loadNotExistingJson() {
        ConfigHelper.lookupJsonConfiguration(this.getClass(), (String[])new String[]{"does-not-exist.json"});
    }
}

