/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.NodeInfo;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;

public class IgniteNodeInfo
implements Binarylizable {
    private NodeInfo nodeInfo;

    public IgniteNodeInfo() {
    }

    public IgniteNodeInfo(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        writer.writeString("host", this.nodeInfo.host());
        writer.writeInt("port", this.nodeInfo.port());
        JsonObject metadata = this.nodeInfo.metadata();
        writer.writeByteArray("meta", metadata != null ? metadata.toBuffer().getBytes() : null);
    }

    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        String host = reader.readString("host");
        int port = reader.readInt("port");
        byte[] bytes = reader.readByteArray("meta");
        this.nodeInfo = new NodeInfo(host, port, bytes != null ? new JsonObject(Buffer.buffer((byte[])bytes)) : null);
    }

    public NodeInfo unwrap() {
        return this.nodeInfo;
    }
}

