/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.spi.cluster.RegistrationInfo;
import java.util.Objects;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;

public class IgniteRegistrationInfo
implements Binarylizable,
Comparable<IgniteRegistrationInfo> {
    private String address;
    private RegistrationInfo registrationInfo;

    public IgniteRegistrationInfo() {
    }

    public IgniteRegistrationInfo(String address, RegistrationInfo registrationInfo) {
        this.address = Objects.requireNonNull(address);
        this.registrationInfo = Objects.requireNonNull(registrationInfo);
    }

    public String address() {
        return this.address;
    }

    public RegistrationInfo registrationInfo() {
        return this.registrationInfo;
    }

    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        writer.writeString("address", this.address);
        writer.writeString("nodeId", this.registrationInfo.nodeId());
        writer.writeLong("seq", this.registrationInfo.seq());
        writer.writeBoolean("isLocalOnly", this.registrationInfo.localOnly());
    }

    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.address = reader.readString("address");
        this.registrationInfo = new RegistrationInfo(reader.readString("nodeId"), reader.readLong("seq"), reader.readBoolean("isLocalOnly"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgniteRegistrationInfo that = (IgniteRegistrationInfo)o;
        if (!this.address.equals(that.address)) {
            return false;
        }
        return this.registrationInfo.equals((Object)that.registrationInfo);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.registrationInfo.hashCode();
        return result;
    }

    @Override
    public int compareTo(IgniteRegistrationInfo other) {
        return Integer.compare(this.hashCode(), other.hashCode());
    }
}

