/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.VertxInternal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Throttling {
    private final VertxInternal vertx;
    private final Function<String, Future<?>> action;
    private final ConcurrentMap<String, State> map;

    public Throttling(VertxInternal vertx, Function<String, Future<?>> action) {
        this.vertx = vertx;
        this.action = action;
        this.map = new ConcurrentHashMap<String, State>();
    }

    public void onEvent(String address) {
        State curr = this.map.compute(address, (s, state) -> state == null ? State.NEW : state.pending());
        if (curr == State.NEW) {
            this.run(address);
        }
    }

    private void run(String address) {
        this.map.computeIfPresent(address, (s, state) -> state.start());
        this.action.apply(address).onComplete(ar -> {
            this.map.computeIfPresent(address, (s, state) -> state.done());
            this.vertx.setTimer(20L, l -> this.checkState(address));
        });
    }

    private void checkState(String address) {
        State curr = this.map.computeIfPresent(address, (s, state) -> state.next());
        if (curr == State.NEW) {
            this.run(address);
        }
    }

    private static enum State {
        NEW{

            @Override
            State pending() {
                return PENDING;
            }

            @Override
            State start() {
                return RUNNING;
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                return RUNNING;
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        RUNNING{

            @Override
            State pending() {
                return RUNNING_PENDING;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                return FINISHED;
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        RUNNING_PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                return FINISHED_PENDING;
            }

            @Override
            State next() {
                throw new IllegalStateException();
            }
        }
        ,
        FINISHED{

            @Override
            State pending() {
                return FINISHED_PENDING;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                return null;
            }
        }
        ,
        FINISHED_PENDING{

            @Override
            State pending() {
                return this;
            }

            @Override
            State start() {
                throw new IllegalStateException();
            }

            @Override
            State done() {
                throw new IllegalStateException();
            }

            @Override
            State next() {
                return NEW;
            }
        };


        abstract State pending();

        abstract State start();

        abstract State done();

        abstract State next();
    }
}

