/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeInfo;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.spi.cluster.ignite.IgniteOptions;
import io.vertx.spi.cluster.ignite.impl.AsyncMapImpl;
import io.vertx.spi.cluster.ignite.impl.IgniteNodeInfo;
import io.vertx.spi.cluster.ignite.impl.MapImpl;
import io.vertx.spi.cluster.ignite.impl.SubsMapHelper;
import io.vertx.spi.cluster.ignite.impl.VertxLogger;
import io.vertx.spi.cluster.ignite.util.ConfigHelper;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lifecycle.LifecycleBean;
import org.apache.ignite.lifecycle.LifecycleEventType;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;

public class IgniteClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(IgniteClusterManager.class);
    private static final String DEFAULT_CONFIG_FILE = "default-ignite.json";
    private static final String CONFIG_FILE = "ignite.json";
    private static final String XML_CONFIG_FILE = "ignite.xml";
    private static final String VERTX_NODE_PREFIX = "vertx.ignite.node.";
    private static final String LOCK_SEMAPHORE_PREFIX = "__vertx.";
    private static final Factory<ExpiryPolicy> DEFAULT_EXPIRY_POLICY_FACTORY = ModifiedExpiryPolicy.factoryOf((Duration)Duration.ETERNAL);
    private static final int[] IGNITE_EVENTS = new int[]{10, 11, 12, 14};
    private VertxInternal vertx;
    private NodeSelector nodeSelector;
    private IgniteConfiguration extCfg;
    private IgniteOptions extOptions;
    private URL extConfigUrl;
    private Ignite ignite;
    private boolean customIgnite;
    private boolean shutdownOnSegmentation;
    private boolean shutdownOnNodeStop;
    private long delayAfterStart;
    private String nodeId;
    private NodeInfo nodeInfo;
    private IgniteCache<String, IgniteNodeInfo> nodeInfoMap;
    private SubsMapHelper subsMapHelper;
    private IgnitePredicate<Event> eventListener;
    private volatile boolean active;
    private volatile NodeListener nodeListener;
    private final Object monitor = new Object();
    private ExecutorService lockReleaseExec;

    public IgniteClusterManager() {
        IgniteClusterManager.setIgniteProperties();
    }

    public IgniteClusterManager(IgniteConfiguration extCfg) {
        IgniteClusterManager.setIgniteProperties();
        this.extCfg = extCfg;
    }

    public IgniteClusterManager(URL configFile) {
        IgniteClusterManager.setIgniteProperties();
        this.extConfigUrl = configFile;
    }

    public IgniteClusterManager(JsonObject jsonConfig) {
        this(new IgniteOptions(jsonConfig));
    }

    public IgniteClusterManager(IgniteOptions extOptions) {
        IgniteClusterManager.setIgniteProperties();
        this.extOptions = extOptions;
    }

    public IgniteClusterManager(Ignite ignite) {
        Objects.requireNonNull(ignite, "Ignite instance can't be null.");
        this.ignite = ignite;
        this.customIgnite = true;
    }

    public Ignite getIgniteInstance() {
        return this.ignite;
    }

    public void init(Vertx vertx, NodeSelector nodeSelector) {
        this.vertx = (VertxInternal)vertx;
        this.nodeSelector = nodeSelector;
    }

    public void nodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }

    public <K, V> void getAsyncMap(String name, Promise<AsyncMap<K, V>> promise) {
        this.vertx.executeBlocking(prom -> prom.complete(new AsyncMapImpl(this.getCache(name), this.vertx))).onComplete(promise);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return new MapImpl<K, V>(this.getCache(name));
    }

    public void getLockWithTimeout(String name, long timeout, Promise<Lock> promise) {
        this.vertx.executeBlocking(prom -> {
            long start;
            boolean locked;
            IgniteSemaphore semaphore = this.ignite.semaphore(LOCK_SEMAPHORE_PREFIX + name, 1, true, true);
            long remaining = timeout;
            do {
                start = System.nanoTime();
            } while (!(locked = semaphore.tryAcquire(remaining, TimeUnit.MILLISECONDS)) && (remaining -= TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS)) > 0L);
            if (!locked) {
                throw new VertxException("Timed out waiting to get lock " + name);
            }
            prom.complete((Object)new LockImpl(semaphore, this.lockReleaseExec));
        }, false).onComplete(promise);
    }

    public void getCounter(String name, Promise<Counter> promise) {
        this.vertx.executeBlocking(prom -> prom.complete((Object)new CounterImpl(this.ignite.atomicLong(name, 0L, true)))).onComplete(promise);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeInfo(NodeInfo nodeInfo, Promise<Void> promise) {
        IgniteClusterManager igniteClusterManager = this;
        synchronized (igniteClusterManager) {
            this.nodeInfo = nodeInfo;
        }
        IgniteNodeInfo value = new IgniteNodeInfo(nodeInfo);
        this.vertx.executeBlocking(prom -> {
            this.nodeInfoMap.put((Object)this.nodeId, (Object)value);
            prom.complete();
        }, false).onComplete(promise);
    }

    public synchronized NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void getNodeInfo(String id, Promise<NodeInfo> promise) {
        this.nodeInfoMap.getAsync((Object)id).listen((IgniteInClosure & Serializable)fut -> {
            try {
                IgniteNodeInfo value = (IgniteNodeInfo)fut.get();
                if (value != null) {
                    promise.complete((Object)value.unwrap());
                } else {
                    promise.fail("Not a member of the cluster");
                }
            }
            catch (IgniteException e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public List<String> getNodes() {
        try {
            return this.ignite.cluster().nodes().stream().map(IgniteClusterManager::nodeId).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            log.debug((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public void join(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            Object object = this.monitor;
            synchronized (object) {
                if (!this.active) {
                    this.active = true;
                    this.lockReleaseExec = Executors.newCachedThreadPool(r -> new Thread(r, "vertx-ignite-service-release-lock-thread"));
                    if (!this.customIgnite) {
                        IgniteConfiguration cfg = this.prepareConfig();
                        cfg.setLifecycleBeans(new LifecycleBean[]{e -> {
                            if (e == LifecycleEventType.AFTER_NODE_STOP && this.shutdownOnNodeStop && this.active) {
                                this.vertx.close();
                            }
                        }});
                        this.ignite = Ignition.start((IgniteConfiguration)cfg);
                    }
                    this.nodeId = IgniteClusterManager.nodeId(this.ignite.cluster().localNode());
                    this.eventListener = (IgnitePredicate & Serializable)event -> {
                        if (!this.isActive()) {
                            return false;
                        }
                        this.vertx.executeBlocking(f -> {
                            String id = IgniteClusterManager.nodeId(((DiscoveryEvent)event).eventNode());
                            switch (event.type()) {
                                case 10: {
                                    this.notifyNodeListener(listener -> listener.nodeAdded(id));
                                    log.debug((Object)("node " + id + " joined the cluster"));
                                    f.complete();
                                    break;
                                }
                                case 11: 
                                case 12: {
                                    if (this.cleanNodeInfos(id)) {
                                        this.cleanSubs(id);
                                    }
                                    this.notifyNodeListener(listener -> listener.nodeLeft(id));
                                    log.debug((Object)("node " + id + " left the cluster"));
                                    f.complete();
                                    break;
                                }
                                case 14: {
                                    if (this.customIgnite || !this.shutdownOnSegmentation) {
                                        log.warn((Object)"node got segmented");
                                    } else {
                                        log.warn((Object)"node got segmented and will be shut down");
                                        this.vertx.close();
                                    }
                                    f.fail((Throwable)new IllegalStateException("node is stopped"));
                                    break;
                                }
                                default: {
                                    f.fail("event not known");
                                }
                            }
                        });
                        return true;
                    };
                    this.ignite.events().localListen(this.eventListener, IGNITE_EVENTS);
                    this.subsMapHelper = new SubsMapHelper(this.ignite, this.nodeSelector, this.vertx);
                    this.nodeInfoMap = this.ignite.getOrCreateCache("__vertx.nodeInfo");
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.delayAfterStart);
                        prom.complete();
                    }
                    catch (InterruptedException e2) {
                        prom.fail((Throwable)e2);
                    }
                }
            }
        }).onComplete(promise);
    }

    public void leave(Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> {
            Object object = this.monitor;
            synchronized (object) {
                if (this.active) {
                    this.active = false;
                    this.lockReleaseExec.shutdown();
                    try {
                        if (this.eventListener != null) {
                            this.ignite.events().stopLocalListen(this.eventListener, IGNITE_EVENTS);
                        }
                        this.subsMapHelper.leave();
                        if (!this.customIgnite) {
                            this.ignite.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                    this.subsMapHelper = null;
                    this.nodeInfoMap = null;
                }
            }
            prom.complete();
        }).onComplete(promise);
    }

    public boolean isActive() {
        return this.active;
    }

    public void addRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> this.subsMapHelper.put(address, registrationInfo).onComplete((Handler)prom), false).onComplete(promise);
    }

    public void removeRegistration(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        this.vertx.executeBlocking(prom -> this.subsMapHelper.remove(address, registrationInfo, (Promise<Void>)prom), false).onComplete(promise);
    }

    public void getRegistrations(String address, Promise<List<RegistrationInfo>> promise) {
        this.vertx.executeBlocking(prom -> this.subsMapHelper.get(address, (Promise<List<RegistrationInfo>>)prom), false).onComplete(promise);
    }

    private void cleanSubs(String id) {
        try {
            this.subsMapHelper.removeAllForNode(id);
        }
        catch (IllegalStateException | CacheException throwable) {
            // empty catch block
        }
    }

    private boolean cleanNodeInfos(String nid) {
        try {
            return this.nodeInfoMap.remove((Object)nid);
        }
        catch (IllegalStateException | CacheException throwable) {
            return false;
        }
    }

    private IgniteConfiguration prepareConfig() {
        IgniteConfiguration cfg = null;
        if (this.extCfg != null) {
            cfg = this.extCfg;
        } else if (IgniteComponentType.SPRING.inClassPath()) {
            try {
                cfg = ConfigHelper.lookupXmlConfiguration(this.getClass(), XML_CONFIG_FILE);
            }
            catch (VertxException e) {
                log.debug((Object)"xml config could not be loaded");
            }
        }
        if (this.extConfigUrl != null) {
            cfg = ConfigHelper.loadConfiguration(this.extConfigUrl);
        }
        if (cfg == null) {
            IgniteOptions options = this.extOptions == null ? new IgniteOptions(ConfigHelper.lookupJsonConfiguration(this.getClass(), CONFIG_FILE, DEFAULT_CONFIG_FILE)) : this.extOptions;
            this.shutdownOnSegmentation = options.isShutdownOnSegmentation();
            this.shutdownOnNodeStop = options.isShutdownOnNodeStop();
            this.delayAfterStart = options.getDelayAfterStart();
            cfg = ConfigHelper.toIgniteConfig((Vertx)this.vertx, options).setGridLogger((IgniteLogger)new VertxLogger());
        }
        UUID uuid = UUID.randomUUID();
        cfg.setNodeId(uuid);
        cfg.setIgniteInstanceName(VERTX_NODE_PREFIX + uuid);
        cfg.setSegmentationPolicy(SegmentationPolicy.NOOP);
        cfg.setFailureHandler((FailureHandler)new StopNodeFailureHandler());
        cfg.setAsyncContinuationExecutor(Runnable::run);
        return cfg;
    }

    private <K, V> IgniteCache<K, V> getCache(String name) {
        IgniteCache cache = this.ignite.getOrCreateCache(name);
        if (((IgniteCacheProxy)cache).context().expiry() == null) {
            return cache.withExpiryPolicy((ExpiryPolicy)DEFAULT_EXPIRY_POLICY_FACTORY.create());
        }
        return cache;
    }

    private void notifyNodeListener(Consumer<NodeListener> notify) {
        if (null == notify) {
            return;
        }
        NodeListener listener = this.nodeListener;
        if (null == listener) {
            return;
        }
        try {
            notify.accept(listener);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static String nodeId(ClusterNode node) {
        return node.id().toString();
    }

    private static void setIgniteProperties() {
        System.setProperty("IGNITE_NO_SHUTDOWN_HOOK", "true");
        System.setProperty("IGNITE_UPDATE_NOTIFIER", "false");
    }

    private class CounterImpl
    implements Counter {
        private final IgniteAtomicLong cnt;

        private CounterImpl(IgniteAtomicLong cnt) {
            this.cnt = cnt;
        }

        public Future<Long> get() {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.get()));
        }

        public void get(Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.get().onComplete(handler);
        }

        public Future<Long> incrementAndGet() {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.incrementAndGet()));
        }

        public void incrementAndGet(Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.incrementAndGet().onComplete(handler);
        }

        public Future<Long> getAndIncrement() {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.getAndIncrement()));
        }

        public void getAndIncrement(Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.getAndIncrement().onComplete(handler);
        }

        public Future<Long> decrementAndGet() {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.decrementAndGet()));
        }

        public void decrementAndGet(Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.decrementAndGet().onComplete(handler);
        }

        public Future<Long> addAndGet(long value) {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.addAndGet(value)));
        }

        public void addAndGet(long value, Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.addAndGet(value).onComplete(handler);
        }

        public Future<Long> getAndAdd(long value) {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.getAndAdd(value)));
        }

        public void getAndAdd(long value, Handler<AsyncResult<Long>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.getAndAdd(value).onComplete(handler);
        }

        public Future<Boolean> compareAndSet(long expected, long value) {
            return IgniteClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.cnt.compareAndSet(expected, value)));
        }

        public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> handler) {
            Objects.requireNonNull(handler, "handler");
            this.compareAndSet(expected, value).onComplete(handler);
        }
    }

    private static class LockImpl
    implements Lock {
        private final IgniteSemaphore semaphore;
        private final Executor lockReleaseExec;
        private final AtomicBoolean released = new AtomicBoolean();

        private LockImpl(IgniteSemaphore semaphore, Executor lockReleaseExec) {
            this.semaphore = semaphore;
            this.lockReleaseExec = lockReleaseExec;
        }

        public void release() {
            if (this.released.compareAndSet(false, true)) {
                this.lockReleaseExec.execute(() -> ((IgniteSemaphore)this.semaphore).release());
            }
        }
    }
}

