/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.spi.cluster.ignite.IgniteCacheOptions;
import io.vertx.spi.cluster.ignite.IgniteDiscoveryOptions;
import io.vertx.spi.cluster.ignite.IgniteMetricExporterOptions;
import io.vertx.spi.cluster.ignite.IgniteOptions;
import io.vertx.spi.cluster.ignite.IgniteSslOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class IgniteOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, IgniteOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "cacheConfiguration": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<IgniteCacheOptions> list = new ArrayList<IgniteCacheOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new IgniteCacheOptions((JsonObject)item));
                        }
                    });
                    obj.setCacheConfiguration(list);
                    break;
                }
                case "clientFailureDetectionTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setClientFailureDetectionTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "connectionsPerNode": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setConnectionsPerNode(((Number)member.getValue()).intValue());
                    break;
                }
                case "defaultRegionInitialSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDefaultRegionInitialSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "defaultRegionMaxSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDefaultRegionMaxSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "defaultRegionMetricsEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDefaultRegionMetricsEnabled((Boolean)member.getValue());
                    break;
                }
                case "delayAfterStart": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setDelayAfterStart(((Number)member.getValue()).longValue());
                    break;
                }
                case "discoverySpi": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setDiscoverySpi(new IgniteDiscoveryOptions((JsonObject)member.getValue()));
                    break;
                }
                case "idleConnectionTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleConnectionTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "localHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocalHost((String)member.getValue());
                    break;
                }
                case "localPort": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLocalPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxConnectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxConnectTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "metricExporterSpi": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setMetricExporterSpi(new IgniteMetricExporterOptions((JsonObject)member.getValue()));
                    break;
                }
                case "metricsExpireTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMetricsExpireTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "metricsHistorySize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMetricsHistorySize(((Number)member.getValue()).intValue());
                    break;
                }
                case "metricsLogFrequency": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMetricsLogFrequency(((Number)member.getValue()).longValue());
                    break;
                }
                case "metricsUpdateFrequency": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMetricsUpdateFrequency(((Number)member.getValue()).longValue());
                    break;
                }
                case "pageSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPageSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectCount": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectCount(((Number)member.getValue()).intValue());
                    break;
                }
                case "shutdownOnNodeStop": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setShutdownOnNodeStop((Boolean)member.getValue());
                    break;
                }
                case "shutdownOnSegmentation": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setShutdownOnSegmentation((Boolean)member.getValue());
                    break;
                }
                case "sslContextFactory": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setSslContextFactory(new IgniteSslOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(IgniteOptions obj, JsonObject json) {
        IgniteOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(IgniteOptions obj, Map<String, Object> json) {
        if (obj.getCacheConfiguration() != null) {
            JsonArray array = new JsonArray();
            obj.getCacheConfiguration().forEach(item -> array.add((Object)item.toJson()));
            json.put("cacheConfiguration", array);
        }
        json.put("clientFailureDetectionTimeout", obj.getClientFailureDetectionTimeout());
        json.put("connectTimeout", obj.getConnectTimeout());
        json.put("connectionsPerNode", obj.getConnectionsPerNode());
        json.put("defaultRegionInitialSize", obj.getDefaultRegionInitialSize());
        json.put("defaultRegionMaxSize", obj.getDefaultRegionMaxSize());
        json.put("defaultRegionMetricsEnabled", obj.isDefaultRegionMetricsEnabled());
        json.put("delayAfterStart", obj.getDelayAfterStart());
        if (obj.getDiscoverySpi() != null) {
            json.put("discoverySpi", obj.getDiscoverySpi().toJson());
        }
        json.put("idleConnectionTimeout", obj.getIdleConnectionTimeout());
        if (obj.getLocalHost() != null) {
            json.put("localHost", obj.getLocalHost());
        }
        json.put("localPort", obj.getLocalPort());
        json.put("maxConnectTimeout", obj.getMaxConnectTimeout());
        if (obj.getMetricExporterSpi() != null) {
            json.put("metricExporterSpi", obj.getMetricExporterSpi().toJson());
        }
        json.put("metricsExpireTime", obj.getMetricsExpireTime());
        json.put("metricsHistorySize", obj.getMetricsHistorySize());
        json.put("metricsLogFrequency", obj.getMetricsLogFrequency());
        json.put("metricsUpdateFrequency", obj.getMetricsUpdateFrequency());
        json.put("pageSize", obj.getPageSize());
        json.put("reconnectCount", obj.getReconnectCount());
        json.put("shutdownOnNodeStop", obj.isShutdownOnNodeStop());
        json.put("shutdownOnSegmentation", obj.isShutdownOnSegmentation());
        if (obj.getSslContextFactory() != null) {
            json.put("sslContextFactory", obj.getSslContextFactory().toJson());
        }
    }
}

