/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.spi.cluster.ignite.IgniteSslOptionsConverter;
import java.util.Map;
import org.apache.ignite.ssl.SslContextFactory;

@DataObject
@JsonGen(publicConverter=false)
public class IgniteSslOptions {
    private String protocol;
    private String keyAlgorithm;
    private String keyStoreType;
    private String keyStoreFilePath;
    private String keyStorePassword;
    private String trustStoreType;
    private String trustStoreFilePath;
    private String trustStorePassword;
    private PemKeyCertOptions pemKeyCertOptions;
    private PemTrustOptions pemTrustOptions;
    private PfxOptions pfxKeyCertOptions;
    private PfxOptions pfxTrustOptions;
    private JksOptions jksKeyCertOptions;
    private JksOptions jksTrustOptions;
    private boolean trustAll;

    public IgniteSslOptions() {
        this.protocol = "TLS";
        this.keyAlgorithm = SslContextFactory.DFLT_KEY_ALGORITHM;
        this.keyStoreType = SslContextFactory.DFLT_STORE_TYPE;
        this.trustStoreType = SslContextFactory.DFLT_STORE_TYPE;
        this.trustAll = false;
    }

    public IgniteSslOptions(IgniteSslOptions options) {
        this.protocol = options.protocol;
        this.keyAlgorithm = options.keyAlgorithm;
        this.keyStoreType = options.keyStoreType;
        this.keyStoreFilePath = options.keyStoreFilePath;
        this.keyStorePassword = options.keyStorePassword;
        this.trustStoreType = options.trustStoreType;
        this.trustStoreFilePath = options.trustStoreFilePath;
        this.trustStorePassword = options.trustStorePassword;
        this.pemKeyCertOptions = options.pemKeyCertOptions;
        this.pemTrustOptions = options.pemTrustOptions;
        this.pfxKeyCertOptions = options.pfxKeyCertOptions;
        this.pfxTrustOptions = options.pfxTrustOptions;
        this.jksKeyCertOptions = options.jksKeyCertOptions;
        this.jksTrustOptions = options.jksTrustOptions;
        this.trustAll = options.trustAll;
    }

    public IgniteSslOptions(JsonObject options) {
        this();
        IgniteSslOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public IgniteSslOptions setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Deprecated
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Deprecated
    public IgniteSslOptions setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    @Deprecated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Deprecated
    public IgniteSslOptions setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    @Deprecated
    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    @Deprecated
    public IgniteSslOptions setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
        return this;
    }

    @Deprecated
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Deprecated
    public IgniteSslOptions setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    @Deprecated
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Deprecated
    public IgniteSslOptions setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    @Deprecated
    public String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    @Deprecated
    public IgniteSslOptions setTrustStoreFilePath(String trustStoreFilePath) {
        this.trustStoreFilePath = trustStoreFilePath;
        return this;
    }

    @Deprecated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Deprecated
    public IgniteSslOptions setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public PemKeyCertOptions getPemKeyCertOptions() {
        return this.pemKeyCertOptions;
    }

    public IgniteSslOptions setPemKeyCertOptions(PemKeyCertOptions pemKeyCertOptions) {
        this.pemKeyCertOptions = pemKeyCertOptions;
        return this;
    }

    public PemTrustOptions getPemTrustOptions() {
        return this.pemTrustOptions;
    }

    public IgniteSslOptions setPemTrustOptions(PemTrustOptions pemTrustOptions) {
        this.pemTrustOptions = pemTrustOptions;
        return this;
    }

    public PfxOptions getPfxKeyCertOptions() {
        return this.pfxKeyCertOptions;
    }

    public IgniteSslOptions setPfxKeyCertOptions(PfxOptions pfxKeyCertOptions) {
        this.pfxKeyCertOptions = pfxKeyCertOptions;
        return this;
    }

    public PfxOptions getPfxTrustOptions() {
        return this.pfxTrustOptions;
    }

    public IgniteSslOptions setPfxTrustOptions(PfxOptions pfxTrustOptions) {
        this.pfxTrustOptions = pfxTrustOptions;
        return this;
    }

    public JksOptions getJksKeyCertOptions() {
        return this.jksKeyCertOptions;
    }

    public IgniteSslOptions setJksKeyCertOptions(JksOptions jksKeyCertOptions) {
        this.jksKeyCertOptions = jksKeyCertOptions;
        return this;
    }

    public JksOptions getJksTrustOptions() {
        return this.jksTrustOptions;
    }

    public IgniteSslOptions setJksTrustOptions(JksOptions jksTrustOptions) {
        this.jksTrustOptions = jksTrustOptions;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public IgniteSslOptions setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        IgniteSslOptionsConverter.toJson(this, json);
        return json;
    }
}

