/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.ignite.impl.ClusterSerializationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class AsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final VertxInternal vertx;
    private final IgniteCache<K, V> cache;

    public AsyncMapImpl(IgniteCache<K, V> cache, VertxInternal vertx) {
        this.cache = cache;
        this.vertx = vertx;
    }

    public Future<V> get(K k) {
        return this.execute(cache -> cache.getAsync(ClusterSerializationUtils.marshal(k)));
    }

    public Future<Void> put(K k, V v) {
        return this.execute(cache -> cache.putAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)));
    }

    public Future<Void> put(K k, V v, long ttl) {
        return this.executeWithTtl(cache -> cache.putAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)), ttl);
    }

    public Future<V> putIfAbsent(K k, V v) {
        return this.execute(cache -> cache.getAndPutIfAbsentAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)));
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        return this.executeWithTtl(cache -> cache.getAndPutIfAbsentAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)), ttl);
    }

    public Future<V> remove(K k) {
        return this.execute(cache -> cache.getAndRemoveAsync(ClusterSerializationUtils.marshal(k)));
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        return this.execute(cache -> cache.removeAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)));
    }

    public Future<V> replace(K k, V v) {
        return this.execute(cache -> cache.getAndReplaceAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)));
    }

    public Future<V> replace(K k, V v, long ttl) {
        return this.executeWithTtl(cache -> cache.getAndReplaceAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(v)), ttl);
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        return this.execute(cache -> cache.replaceAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(oldValue), ClusterSerializationUtils.marshal(newValue)));
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        return this.executeWithTtl(cache -> cache.replaceAsync(ClusterSerializationUtils.marshal(k), ClusterSerializationUtils.marshal(oldValue), ClusterSerializationUtils.marshal(newValue)), ttl);
    }

    public Future<Void> clear() {
        return this.execute(IgniteCache::clearAsync);
    }

    public Future<Integer> size() {
        return this.execute(rec$ -> ((IgniteCache)rec$).sizeAsync(new CachePeekMode[0]));
    }

    public Future<Set<K>> keys() {
        return this.entries().map(Map::keySet);
    }

    public Future<List<V>> values() {
        return this.entries().map(map -> new ArrayList(map.values()));
    }

    public Future<Map<K, V>> entries() {
        return this.vertx.executeBlocking(promise -> {
            try {
                List all = this.cache.query((Query)new ScanQuery()).getAll();
                HashMap<Object, Object> map = new HashMap<Object, Object>(all.size());
                for (Cache.Entry entry : all) {
                    map.put(ClusterSerializationUtils.unmarshal(entry.getKey()), ClusterSerializationUtils.unmarshal(entry.getValue()));
                }
                promise.complete(map);
            }
            catch (RuntimeException cause) {
                promise.fail((Throwable)new VertxException((Throwable)cause));
            }
        });
    }

    private <T> Future<T> execute(Function<IgniteCache<K, V>, IgniteFuture<T>> cacheOp) {
        return this.executeWithTtl(cacheOp, -1L);
    }

    private <T> Future<T> executeWithTtl(Function<IgniteCache<K, V>, IgniteFuture<T>> cacheOp, long ttl) {
        IgniteCache cache0 = ttl > 0L ? this.cache.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl))) : this.cache;
        return this.vertx.executeBlocking(promise -> {
            IgniteFuture future = (IgniteFuture)cacheOp.apply(cache0);
            future.listen((IgniteInClosure & Serializable)fut -> {
                try {
                    promise.complete(ClusterSerializationUtils.unmarshal(future.get()));
                }
                catch (RuntimeException e) {
                    promise.fail((Throwable)new VertxException((Throwable)e));
                }
            });
        });
    }
}

