/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import io.vertx.spi.cluster.ignite.impl.IgniteRegistrationInfo;
import io.vertx.spi.cluster.ignite.impl.Throttling;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.StreamSupport;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.lang.IgniteBiPredicate;

public class SubsMapHelper {
    private static final Logger log = LoggerFactory.getLogger(SubsMapHelper.class);
    private final IgniteCache<IgniteRegistrationInfo, Boolean> map;
    private final NodeSelector nodeSelector;
    private final ConcurrentMap<String, Set<RegistrationInfo>> localSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final Throttling throttling;
    private volatile boolean shutdown;

    public SubsMapHelper(Ignite ignite, NodeSelector nodeSelector, VertxInternal vertxInternal) {
        this.map = ignite.getOrCreateCache("__vertx.subs");
        this.nodeSelector = nodeSelector;
        this.throttling = new Throttling(vertxInternal, a -> this.getAndUpdate((String)a, vertxInternal));
        this.shutdown = false;
        this.map.query((Query)new ContinuousQuery().setAutoUnsubscribe(true).setTimeInterval(100L).setPageSize(128).setLocalListener(l -> this.listen(l, vertxInternal)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegistrationInfo> get(String address) {
        if (this.shutdown) {
            return null;
        }
        try {
            ArrayList<Object> infos;
            List remote = this.map.query((Query)new ScanQuery((IgniteBiPredicate & Serializable)(k, v) -> k.address().equals(address))).getAll();
            int size = remote.size();
            Set local = (Set)this.localSubs.get(address);
            if (local != null) {
                Set set = local;
                synchronized (set) {
                    if ((size += local.size()) == 0) {
                        return Collections.emptyList();
                    }
                    infos = new ArrayList(size);
                    infos.addAll(local);
                }
            } else {
                if (size == 0) {
                    return Collections.emptyList();
                }
                infos = new ArrayList<RegistrationInfo>(size);
            }
            for (Cache.Entry info : remote) {
                infos.add(((IgniteRegistrationInfo)info.getKey()).registrationInfo());
            }
            return infos;
        }
        catch (IllegalStateException | CacheException e) {
            throw new VertxException(e);
        }
    }

    public Void put(String address, RegistrationInfo registrationInfo) {
        if (this.shutdown) {
            throw new VertxException("shutdown in progress");
        }
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.compute(address, (add, curr) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.map.put((Object)new IgniteRegistrationInfo(address, registrationInfo), (Object)Boolean.TRUE);
            }
        }
        catch (IllegalStateException | CacheException e) {
            throw new VertxException(e);
        }
        return null;
    }

    private Set<RegistrationInfo> addToSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        Set<RegistrationInfo> res = curr != null ? curr : Collections.synchronizedSet(new LinkedHashSet());
        res.add(registrationInfo);
        return res;
    }

    public Void remove(String address, RegistrationInfo registrationInfo) {
        if (this.shutdown) {
            return null;
        }
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.computeIfPresent(address, (add, curr) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.fireRegistrationUpdateEvent(address);
            } else {
                this.map.remove((Object)new IgniteRegistrationInfo(address, registrationInfo), (Object)Boolean.TRUE);
            }
        }
        catch (IllegalStateException | CacheException e) {
            throw new VertxException(e);
        }
        return null;
    }

    private Set<RegistrationInfo> removeFromSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        curr.remove(registrationInfo);
        return curr.isEmpty() ? null : curr;
    }

    public void removeAllForNode(String nodeId) {
        List toRemove = this.map.query((Query)new ScanQuery((IgniteBiPredicate & Serializable)(k, v) -> k.registrationInfo().nodeId().equals(nodeId))).getAll();
        for (Cache.Entry info : toRemove) {
            try {
                this.map.remove(info.getKey(), (Object)Boolean.TRUE);
            }
            catch (IllegalStateException | CacheException t) {
                log.warn((Object)("Could not remove subscriber: " + t.getMessage()));
            }
        }
    }

    public void leave() {
        this.shutdown = true;
    }

    private void fireRegistrationUpdateEvent(String address) {
        this.throttling.onEvent(address);
    }

    private Future<List<RegistrationInfo>> getAndUpdate(String address, VertxInternal vertxInternal) {
        Promise prom = Promise.promise();
        if (this.nodeSelector.wantsUpdatesFor(address)) {
            prom.future().onSuccess(registrationInfos -> this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, registrationInfos)));
            vertxInternal.executeBlocking(() -> this.get(address), false).onComplete((Handler)prom);
        } else {
            prom.complete();
        }
        return prom.future();
    }

    private void listen(Iterable<CacheEntryEvent<? extends IgniteRegistrationInfo, ? extends Boolean>> events, VertxInternal vertxInternal) {
        vertxInternal.executeBlocking(() -> {
            StreamSupport.stream(events.spliterator(), false).map(e -> ((IgniteRegistrationInfo)e.getKey()).address()).distinct().forEach(this::fireRegistrationUpdateEvent);
            return null;
        }, false);
    }
}

