/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.util;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.spi.cluster.ignite.IgniteCacheOptions;
import io.vertx.spi.cluster.ignite.IgniteDiscoveryOptions;
import io.vertx.spi.cluster.ignite.IgniteMetricExporterOptions;
import io.vertx.spi.cluster.ignite.IgniteOptions;
import io.vertx.spi.cluster.ignite.IgniteSslOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.cache.configuration.Factory;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.ssl.SslContextFactory;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static IgniteConfiguration loadConfiguration(URL config) {
        try {
            return (IgniteConfiguration)F.first((Iterable)((Iterable)IgnitionEx.loadConfigurations((URL)config).get1()));
        }
        catch (IgniteCheckedException e) {
            throw new VertxException((Throwable)e);
        }
    }

    public static IgniteConfiguration lookupXmlConfiguration(Class<?> clazz, String ... files) {
        InputStream is = ConfigHelper.lookupFiles(clazz, files);
        try {
            return (IgniteConfiguration)F.first((Iterable)((Iterable)IgnitionEx.loadConfigurations((InputStream)is).get1()));
        }
        catch (IllegalArgumentException | IgniteCheckedException e) {
            throw new VertxException(e);
        }
    }

    public static JsonObject lookupJsonConfiguration(Class<?> clazz, String ... files) {
        InputStream is = ConfigHelper.lookupFiles(clazz, files);
        try {
            return new JsonObject(ConfigHelper.readFromInputStream(is));
        }
        catch (DecodeException | IOException | NullPointerException e) {
            throw new VertxException(e);
        }
    }

    public static InputStream lookupFiles(Class<?> clazz, String ... files) {
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        for (String file : files) {
            if (ctxClsLoader != null) {
                is = ctxClsLoader.getResourceAsStream(file);
            }
            if (is == null) {
                is = clazz.getClassLoader().getResourceAsStream(file);
            }
            if (is != null) break;
        }
        return is;
    }

    private static String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }

    public static IgniteConfiguration toIgniteConfig(Vertx vertx, IgniteOptions options) {
        IgniteConfiguration configuration = new IgniteConfiguration();
        configuration.setLocalHost(options.getLocalHost()).setCommunicationSpi((CommunicationSpi)new TcpCommunicationSpi().setLocalPort(options.getLocalPort()).setConnectionsPerNode(options.getConnectionsPerNode()).setConnectTimeout(options.getConnectTimeout()).setIdleConnectionTimeout(options.getIdleConnectionTimeout()).setMaxConnectTimeout(options.getMaxConnectTimeout()).setReconnectCount(options.getReconnectCount())).setDiscoverySpi(ConfigHelper.toDiscoverySpiConfig(options.getDiscoverySpi())).setMetricExporterSpi(ConfigHelper.toMetricExporterSpi(options.getMetricExporterSpi())).setCacheConfiguration((CacheConfiguration[])options.getCacheConfiguration().stream().map(ConfigHelper::toCacheConfiguration).toArray(CacheConfiguration[]::new)).setMetricsLogFrequency(options.getMetricsLogFrequency()).setMetricsUpdateFrequency(options.getMetricsUpdateFrequency()).setClientFailureDetectionTimeout(options.getClientFailureDetectionTimeout()).setMetricsHistorySize(options.getMetricsHistorySize()).setMetricsExpireTime(options.getMetricsExpireTime());
        if (options.getSslContextFactory() != null) {
            configuration.setSslContextFactory(ConfigHelper.toSslContextFactoryConfig(vertx, options.getSslContextFactory()));
        }
        configuration.setDataStorageConfiguration(new DataStorageConfiguration().setPageSize(options.getPageSize()).setDefaultDataRegionConfiguration(new DataRegionConfiguration().setName("default").setInitialSize(options.getDefaultRegionInitialSize()).setMaxSize(Math.max(options.getDefaultRegionMaxSize(), options.getDefaultRegionInitialSize())).setMetricsEnabled(options.isDefaultRegionMetricsEnabled())));
        return configuration;
    }

    public static Factory<SSLContext> toSslContextFactoryConfig(Vertx vertx, IgniteSslOptions options) {
        if (options.getKeyStoreFilePath() == null || options.getKeyStoreFilePath().isEmpty()) {
            return ConfigHelper.createSslFactory(vertx, options);
        }
        return ConfigHelper.createIgniteSslFactory(options);
    }

    @Deprecated
    private static Factory<SSLContext> createIgniteSslFactory(IgniteSslOptions options) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setProtocol(options.getProtocol());
        sslContextFactory.setKeyAlgorithm(options.getKeyAlgorithm());
        sslContextFactory.setKeyStoreType(options.getKeyStoreType());
        sslContextFactory.setKeyStoreFilePath(options.getKeyStoreFilePath());
        if (options.getKeyStorePassword() != null) {
            sslContextFactory.setKeyStorePassword(options.getKeyStorePassword().toCharArray());
        }
        sslContextFactory.setTrustStoreType(options.getTrustStoreType());
        sslContextFactory.setTrustStoreFilePath(options.getTrustStoreFilePath());
        if (options.getTrustStorePassword() != null) {
            sslContextFactory.setTrustStorePassword(options.getTrustStorePassword().toCharArray());
        }
        if (options.isTrustAll()) {
            sslContextFactory.setTrustManagers(new TrustManager[]{SslContextFactory.getDisabledTrustManager()});
        }
        return sslContextFactory;
    }

    private static Factory<SSLContext> createSslFactory(Vertx vertx, IgniteSslOptions options) {
        SecureRandom random = new SecureRandom();
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        try {
            keyManagers.addAll(ConfigHelper.toKeyManagers(vertx, (KeyCertOptions)options.getPemKeyCertOptions()));
            trustManagers.addAll(ConfigHelper.toTrustManagers(vertx, (TrustOptions)options.getPemTrustOptions()));
            keyManagers.addAll(ConfigHelper.toKeyManagers(vertx, (KeyCertOptions)options.getPfxKeyCertOptions()));
            trustManagers.addAll(ConfigHelper.toTrustManagers(vertx, (TrustOptions)options.getPfxTrustOptions()));
            keyManagers.addAll(ConfigHelper.toKeyManagers(vertx, (KeyCertOptions)options.getJksKeyCertOptions()));
            trustManagers.addAll(ConfigHelper.toTrustManagers(vertx, (TrustOptions)options.getPfxTrustOptions()));
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
        if (keyManagers.isEmpty()) {
            return null;
        }
        if (options.isTrustAll()) {
            trustManagers.clear();
            trustManagers.add(SslContextFactory.getDisabledTrustManager());
        }
        KeyManager[] keyManagerArray = keyManagers.toArray(new KeyManager[0]);
        TrustManager[] trustManagerArray = trustManagers.toArray(new TrustManager[0]);
        return (Factory & Serializable)() -> {
            try {
                SSLContext sslContext = SSLContext.getInstance(options.getProtocol());
                sslContext.init(keyManagerArray, trustManagerArray, random);
                return sslContext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IgniteException((Throwable)e);
            }
        };
    }

    private static List<KeyManager> toKeyManagers(Vertx vertx, KeyCertOptions keyCertOptions) throws Exception {
        if (keyCertOptions != null) {
            return Arrays.asList(keyCertOptions.getKeyManagerFactory(vertx).getKeyManagers());
        }
        return new ArrayList<KeyManager>();
    }

    private static List<TrustManager> toTrustManagers(Vertx vertx, TrustOptions trustOptions) throws Exception {
        if (trustOptions != null) {
            return Arrays.asList(trustOptions.getTrustManagerFactory(vertx).getTrustManagers());
        }
        return new ArrayList<TrustManager>();
    }

    private static DiscoverySpi toDiscoverySpiConfig(IgniteDiscoveryOptions options) {
        if (options.getCustomSpi() != null) {
            return options.getCustomSpi();
        }
        JsonObject properties = options.getProperties();
        switch (options.getType()) {
            case "TcpDiscoveryVmIpFinder": {
                return new TcpDiscoverySpi().setJoinTimeout(properties.getLong("joinTimeout", Long.valueOf(0L)).longValue()).setLocalAddress(properties.getString("localAddress", null)).setLocalPort(properties.getInteger("localPort", Integer.valueOf(47500)).intValue()).setLocalPortRange(properties.getInteger("localPortRange", Integer.valueOf(100)).intValue()).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder().setAddresses((Collection)properties.getJsonArray("addresses", new JsonArray()).stream().map(Object::toString).collect(Collectors.toList())));
            }
            case "TcpDiscoveryMulticastIpFinder": {
                return new TcpDiscoverySpi().setJoinTimeout(properties.getLong("joinTimeout", Long.valueOf(0L)).longValue()).setLocalAddress(properties.getString("localAddress", null)).setLocalPort(properties.getInteger("localPort", Integer.valueOf(47500)).intValue()).setLocalPortRange(properties.getInteger("localPortRange", Integer.valueOf(100)).intValue()).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryMulticastIpFinder().setAddressRequestAttempts(properties.getInteger("addressRequestAttempts", Integer.valueOf(2)).intValue()).setLocalAddress(properties.getString("localAddress", null)).setMulticastGroup(properties.getString("multicastGroup", "228.1.2.4")).setMulticastPort(properties.getInteger("multicastPort", Integer.valueOf(47400)).intValue()).setResponseWaitTime(properties.getInteger("responseWaitTime", Integer.valueOf(500)).intValue()).setTimeToLive(properties.getInteger("timeToLive", Integer.valueOf(-1)).intValue()).setAddresses((Collection)properties.getJsonArray("addresses", new JsonArray()).stream().map(Object::toString).collect(Collectors.toList())));
            }
        }
        throw new VertxException("not discovery spi found");
    }

    /*
     * Exception decompiling
     */
    private static MetricExporterSpi[] toMetricExporterSpi(IgniteMetricExporterOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static CacheConfiguration toCacheConfiguration(IgniteCacheOptions options) {
        CacheConfiguration cfg = new CacheConfiguration().setName(options.getName()).setCacheMode(CacheMode.valueOf((String)options.getCacheMode())).setBackups(options.getBackups()).setReadFromBackup(options.isReadFromBackup()).setAtomicityMode(CacheAtomicityMode.valueOf((String)options.getAtomicityMode())).setWriteSynchronizationMode(CacheWriteSynchronizationMode.valueOf((String)options.getWriteSynchronizationMode())).setCopyOnRead(options.isCopyOnRead()).setEagerTtl(options.isEagerTtl()).setEncryptionEnabled(options.isEncryptionEnabled()).setGroupName(options.getGroupName()).setInvalidate(options.isInvalidate()).setMaxConcurrentAsyncOperations(options.getMaxConcurrentAsyncOperations()).setOnheapCacheEnabled(options.isOnheapCacheEnabled()).setPartitionLossPolicy(PartitionLossPolicy.valueOf((String)options.getPartitionLossPolicy())).setRebalanceMode(CacheRebalanceMode.valueOf((String)options.getRebalanceMode())).setRebalanceOrder(options.getRebalanceOrder()).setRebalanceDelay(options.getRebalanceDelay()).setMaxQueryIteratorsCount(options.getMaxQueryInteratorsCount()).setEventsDisabled(options.isEventsDisabled()).setStatisticsEnabled(options.isMetricsEnabled());
        if (options.getExpiryPolicy() != null) {
            Factory factory;
            Duration duration = new Duration(TimeUnit.MILLISECONDS, options.getExpiryPolicy().getLong("duration").longValue());
            switch (options.getExpiryPolicy().getString("type", "created")) {
                case "accessed": {
                    factory = AccessedExpiryPolicy.factoryOf((Duration)duration);
                    break;
                }
                case "modified": {
                    factory = ModifiedExpiryPolicy.factoryOf((Duration)duration);
                    break;
                }
                case "touched": {
                    factory = TouchedExpiryPolicy.factoryOf((Duration)duration);
                    break;
                }
                default: {
                    factory = CreatedExpiryPolicy.factoryOf((Duration)duration);
                }
            }
            cfg.setExpiryPolicyFactory(factory);
        }
        return cfg;
    }
}

