/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;

public class InfinispanAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final AdvancedCache<Object, Object> cache;

    public InfinispanAsyncMap(Vertx vertx, Cache<Object, Object> cache) {
        this.vertx = vertx;
        this.cache = cache.getAdvancedCache();
    }

    private <T> void whenComplete(CompletableFuture<T> completableFuture, Future<T> future) {
        Context context = this.vertx.getOrCreateContext();
        completableFuture.whenComplete((v, t) -> {
            if (t != null) {
                context.runOnContext(h -> future.fail(t));
            } else {
                context.runOnContext(h -> future.complete(v));
            }
        });
    }

    public void get(K k, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Future vertxFuture = Future.future();
        vertxFuture.map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.getAsync(kk), vertxFuture);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.map((Object)null).setHandler(completionHandler);
        this.whenComplete(this.cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync(kk, vv), vertxFuture);
    }

    public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.map((Object)null).setHandler(completionHandler);
        this.whenComplete(this.cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync(kk, vv, ttl, TimeUnit.MILLISECONDS), vertxFuture);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.map(DataConverter::fromCachedObject).setHandler(completionHandler);
        this.whenComplete(this.cache.putIfAbsentAsync(kk, vv), vertxFuture);
    }

    public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.map(DataConverter::fromCachedObject).setHandler(completionHandler);
        this.whenComplete(this.cache.putIfAbsentAsync(kk, vv, ttl, TimeUnit.MILLISECONDS), vertxFuture);
    }

    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Future vertxFuture = Future.future();
        vertxFuture.map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.removeAsync(kk), vertxFuture);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.setHandler(resultHandler);
        this.whenComplete(this.cache.removeAsync(kk, vv), vertxFuture);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Future vertxFuture = Future.future();
        vertxFuture.map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.replaceAsync(kk, vv), vertxFuture);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object oo = DataConverter.toCachedObject(oldValue);
        Object nn = DataConverter.toCachedObject(newValue);
        Future vertxFuture = Future.future();
        vertxFuture.setHandler(resultHandler);
        this.whenComplete(this.cache.replaceAsync(kk, oo, nn), vertxFuture);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        Future vertxFuture = Future.future();
        vertxFuture.setHandler(resultHandler);
        this.whenComplete(this.cache.clearAsync(), vertxFuture);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.cache.size()), false, resultHandler);
    }
}

