/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ChoosableIterable;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.stream.CacheCollectors;

public class InfinispanAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V> {
    private final VertxInternal vertx;
    private final Cache<MultiMapKey, Object> cache;
    private final ConcurrentMap<K, ChoosableSet<V>> nearCache;
    private final AtomicInteger getInProgressCount;
    private final TaskQueue taskQueue;

    public InfinispanAsyncMultiMap(Vertx vertx, Cache<MultiMapKey, Object> cache) {
        this.vertx = (VertxInternal)vertx;
        this.cache = cache;
        this.nearCache = new ConcurrentHashMap<K, ChoosableSet<V>>();
        this.getInProgressCount = new AtomicInteger();
        cache.addListener((Object)new EntryListener());
        this.taskQueue = new TaskQueue();
    }

    public void add(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        this.vertx.getOrCreateContext().executeBlocking(fut -> {
            this.cache.put((Object)new MultiMapKey(kk, vv), (Object)MeaningLessValue.INSTANCE);
            fut.complete();
        }, this.taskQueue, completionHandler);
    }

    public void get(K k, Handler<AsyncResult<ChoosableIterable<V>>> resultHandler) {
        ChoosableSet entries = (ChoosableSet)this.nearCache.get(k);
        if (entries != null && entries.isInitialised() && this.getInProgressCount.get() == 0) {
            resultHandler.handle((Object)Future.succeededFuture((Object)entries));
        } else {
            this.getInProgressCount.incrementAndGet();
            this.vertx.getOrCreateContext().executeBlocking(fut -> {
                ChoosableSet prev;
                ChoosableSet sids;
                List collect = (List)this.cache.keySet().parallelStream().filter((Predicate)new KeyEqualsPredicate(DataConverter.toCachedObject(k))).collect(CacheCollectors.serializableCollector(Collectors::toList));
                Collection entries2 = collect.stream().map(mmk -> DataConverter.fromCachedObject(mmk.getValue())).collect(Collectors.toList());
                if (entries2 != null) {
                    sids = new ChoosableSet(entries2.size());
                    for (Object hid : entries2) {
                        sids.add(hid);
                    }
                } else {
                    sids = new ChoosableSet(0);
                }
                ChoosableSet choosableSet = prev = sids.isEmpty() ? null : this.nearCache.putIfAbsent(k, sids);
                if (prev != null) {
                    prev.merge(sids);
                    sids = prev;
                }
                sids.setInitialised();
                fut.complete(sids);
            }, this.taskQueue, res -> {
                this.getInProgressCount.decrementAndGet();
                resultHandler.handle(res);
            });
        }
    }

    public void remove(K k, V v, Handler<AsyncResult<Boolean>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        this.vertx.getOrCreateContext().executeBlocking(fut -> fut.complete((Object)this.cache.remove((Object)new MultiMapKey(kk, vv), (Object)MeaningLessValue.INSTANCE)), this.taskQueue, completionHandler);
    }

    public void removeAllForValue(V v, Handler<AsyncResult<Void>> completionHandler) {
        this.removeAllMatching(v::equals, completionHandler);
    }

    public void removeAllMatching(Predicate<V> p, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.getOrCreateContext().executeBlocking(future -> {
            this.cache.keySet().removeIf(multiMapKey -> p.test(DataConverter.fromCachedObject(multiMapKey.getValue())));
            future.complete();
        }, this.taskQueue, completionHandler);
    }

    public void clearCache() {
        this.nearCache.clear();
    }

    private static class ChoosableSet<T>
    implements ChoosableIterable<T> {
        private volatile boolean initialised;
        private final Set<T> ids;
        private volatile Iterator<T> iter;

        public ChoosableSet(int initialSize) {
            this.ids = new ConcurrentHashSet(initialSize);
        }

        public boolean isInitialised() {
            return this.initialised;
        }

        public void setInitialised() {
            this.initialised = true;
        }

        public void add(T elem) {
            this.ids.add(elem);
        }

        public void remove(T elem) {
            this.ids.remove(elem);
        }

        public void merge(ChoosableSet<T> toMerge) {
            this.ids.addAll(toMerge.ids);
        }

        public boolean isEmpty() {
            return this.ids.isEmpty();
        }

        public Iterator<T> iterator() {
            return this.ids.iterator();
        }

        public synchronized T choose() {
            if (!this.ids.isEmpty()) {
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = this.ids.iterator();
                }
                try {
                    return this.iter.next();
                }
                catch (NoSuchElementException e) {
                    return null;
                }
            }
            return null;
        }
    }

    @SerializeWith(value=KeyEqualsPredicateExternalizer.class)
    public static class KeyEqualsPredicate
    implements Predicate<MultiMapKey> {
        private final Object kk;

        public KeyEqualsPredicate(Object kk) {
            this.kk = kk;
        }

        @Override
        public boolean test(MultiMapKey mmk) {
            return mmk.getKey().equals(this.kk);
        }

        public static class KeyEqualsPredicateExternalizer
        implements Externalizer<KeyEqualsPredicate> {
            public void writeObject(ObjectOutput output, KeyEqualsPredicate object) throws IOException {
                output.writeObject(object.kk);
            }

            public KeyEqualsPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new KeyEqualsPredicate(input.readObject());
            }
        }
    }

    @SerializeWith(value=MeaningLessValueExternalizer.class)
    public static class MeaningLessValue {
        public static final MeaningLessValue INSTANCE = new MeaningLessValue();

        private MeaningLessValue() {
        }

        public static class MeaningLessValueExternalizer
        implements Externalizer<MeaningLessValue> {
            public void writeObject(ObjectOutput output, MeaningLessValue object) throws IOException {
            }

            public MeaningLessValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=MultiMapKeyExternalizer.class)
    public static class MultiMapKey {
        private final Object key;
        private final Object value;

        public MultiMapKey(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiMapKey that = (MultiMapKey)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public static class MultiMapKeyExternalizer
        implements Externalizer<MultiMapKey> {
            public void writeObject(ObjectOutput output, MultiMapKey object) throws IOException {
                output.writeObject(object.key);
                output.writeObject(object.value);
            }

            public MultiMapKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new MultiMapKey(input.readObject(), input.readObject());
            }
        }
    }

    @Listener(clustered=true, observation=Listener.Observation.POST)
    private class EntryListener {
        private EntryListener() {
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryCreatedEvent<MultiMapKey, Object> event) {
            MultiMapKey multiMapKey = (MultiMapKey)event.getKey();
            Object k = DataConverter.fromCachedObject(multiMapKey.getKey());
            Object v = DataConverter.fromCachedObject(multiMapKey.getValue());
            ChoosableSet entries = (ChoosableSet)InfinispanAsyncMultiMap.this.nearCache.get(k);
            if (entries == null) {
                entries = new ChoosableSet(1);
                ChoosableSet prev = InfinispanAsyncMultiMap.this.nearCache.putIfAbsent(k, entries);
                if (prev != null) {
                    entries = prev;
                }
            }
            entries.add(v);
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent<MultiMapKey, Object> event) {
            MultiMapKey multiMapKey = (MultiMapKey)event.getKey();
            Object k = DataConverter.fromCachedObject(multiMapKey.getKey());
            Object v = DataConverter.fromCachedObject(multiMapKey.getValue());
            ChoosableSet entries = (ChoosableSet)InfinispanAsyncMultiMap.this.nearCache.get(k);
            if (entries != null) {
                entries.remove(v);
                if (entries.isEmpty()) {
                    InfinispanAsyncMultiMap.this.nearCache.remove(k);
                }
            }
        }
    }
}

