/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.ext.cluster.infinispan.impl.InfinispanAsyncMapImpl;
import io.vertx.ext.cluster.infinispan.impl.InfinispanAsyncMultiMap;
import io.vertx.ext.cluster.infinispan.impl.InfinispanCounter;
import io.vertx.ext.cluster.infinispan.impl.InfinispanLock;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.lock.EmbeddedClusteredLockManagerFactory;
import org.infinispan.lock.api.ClusteredLock;
import org.infinispan.lock.impl.manager.EmbeddedClusteredLockManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.impl.EmbeddedMultimapCache;
import org.infinispan.multimap.impl.EmbeddedMultimapCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.MergeEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;

public class InfinispanClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(InfinispanClusterManager.class);
    private static final String VERTX_INFINISPAN_CONFIG_PROP_NAME = "vertx.infinispan.config";
    private static final String INFINISPAN_XML = "infinispan.xml";
    private static final String DEFAULT_INFINISPAN_XML = "default-infinispan.xml";
    private static final String VERTX_JGROUPS_CONFIG_PROP_NAME = "vertx.jgroups.config";
    private static final String JGROUPS_XML = "jgroups.xml";
    private final String ispnConfigPath;
    private final String jgroupsConfigPath;
    private final boolean userProvidedCacheManager;
    private Vertx vertx;
    private DefaultCacheManager cacheManager;
    private NodeListener nodeListener;
    private EmbeddedMultimapCacheManager<Object, Object> multimapCacheManager;
    private EmbeddedClusteredLockManager lockManager;
    private CounterManager counterManager;
    private volatile boolean active;
    private ClusterViewListener viewListener;
    private Set<InfinispanAsyncMultiMap> multimaps = Collections.newSetFromMap(new WeakHashMap(1));

    public InfinispanClusterManager() {
        this.ispnConfigPath = System.getProperty(VERTX_INFINISPAN_CONFIG_PROP_NAME, INFINISPAN_XML);
        this.jgroupsConfigPath = System.getProperty(VERTX_JGROUPS_CONFIG_PROP_NAME, JGROUPS_XML);
        this.userProvidedCacheManager = false;
    }

    public InfinispanClusterManager(DefaultCacheManager cacheManager) {
        Objects.requireNonNull(cacheManager, "cacheManager");
        this.cacheManager = cacheManager;
        this.ispnConfigPath = null;
        this.jgroupsConfigPath = null;
        this.userProvidedCacheManager = true;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheManager;
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            EmbeddedMultimapCache multimapCache = (EmbeddedMultimapCache)this.multimapCacheManager.get(name);
            InfinispanAsyncMultiMap asyncMultiMap = new InfinispanAsyncMultiMap(this.vertx, (EmbeddedMultimapCache<Object, Object>)multimapCache);
            InfinispanClusterManager infinispanClusterManager = this;
            synchronized (infinispanClusterManager) {
                this.multimaps.add(asyncMultiMap);
            }
            future.complete(asyncMultiMap);
        }, false, resultHandler);
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            EmbeddedCacheManagerAdmin administration = this.cacheManager.administration();
            Cache cache = administration.getOrCreateCache(name, "__vertx.distributed.cache.configuration");
            future.complete(new InfinispanAsyncMapImpl(this.vertx, (Cache<Object, Object>)cache));
        }, false, resultHandler);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        return this.cacheManager.getCache(name);
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            if (!this.lockManager.isDefined(name)) {
                this.lockManager.defineLock(name);
            }
            fut.complete((Object)this.lockManager.get(name));
        }, false, ar -> {
            if (ar.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                ClusteredLock lock = (ClusteredLock)ar.result();
                Context context = this.vertx.getOrCreateContext();
                lock.tryLock(timeout, TimeUnit.MILLISECONDS).whenCompleteAsync((locked, throwable) -> {
                    if (throwable != null) {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
                    } else if (locked == Boolean.TRUE) {
                        resultHandler.handle((Object)Future.succeededFuture((Object)new InfinispanLock(lock)));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((String)("Timed out waiting to get lock " + name)));
                    }
                }, command -> context.runOnContext(v -> command.run()));
            }
        });
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            if (!this.counterManager.isDefined(name)) {
                this.counterManager.defineCounter(name, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
            }
            future.complete((Object)new InfinispanCounter(this.vertx, this.counterManager.getStrongCounter(name).sync()));
        }, false, resultHandler);
    }

    public String getNodeID() {
        return this.cacheManager.getNodeAddress();
    }

    public List<String> getNodes() {
        return this.cacheManager.getTransport().getMembers().stream().map(Object::toString).collect(Collectors.toList());
    }

    public synchronized void nodeListener(NodeListener nodeListener) {
        this.nodeListener = nodeListener;
    }

    public void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            if (this.active) {
                future.complete();
                return;
            }
            this.active = true;
            if (!this.userProvidedCacheManager) {
                InputStream ispnConfigStream = null;
                try {
                    FileLookup fileLookup = FileLookupFactory.newInstance();
                    ispnConfigStream = fileLookup.lookupFile(this.ispnConfigPath, this.getCTCCL());
                    if (ispnConfigStream == null) {
                        log.warn((Object)("Cannot find Infinispan config '" + this.ispnConfigPath + "', using default"));
                        ispnConfigStream = fileLookup.lookupFileStrict(DEFAULT_INFINISPAN_XML, this.getCTCCL());
                    }
                    ConfigurationBuilderHolder builderHolder = new ParserRegistry().parse(ispnConfigStream);
                    ClassLoader classLoader = this.getCTCCL();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    builderHolder.getGlobalConfigurationBuilder().classLoader(classLoader);
                    if (fileLookup.lookupFileLocation(this.jgroupsConfigPath, this.getCTCCL()) != null) {
                        log.warn((Object)("Forcing JGroups config to '" + this.jgroupsConfigPath + "'"));
                        builderHolder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", this.jgroupsConfigPath);
                    }
                    this.cacheManager = new DefaultCacheManager(builderHolder, true);
                    this.safeClose(ispnConfigStream);
                }
                catch (IOException e) {
                    try {
                        future.fail((Throwable)e);
                        this.safeClose(ispnConfigStream);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.safeClose(ispnConfigStream);
                        throw throwable;
                    }
                }
            }
            this.viewListener = new ClusterViewListener();
            this.cacheManager.addListener((Object)this.viewListener);
            try {
                this.multimapCacheManager = (EmbeddedMultimapCacheManager)EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)this.cacheManager);
                this.lockManager = (EmbeddedClusteredLockManager)EmbeddedClusteredLockManagerFactory.from((EmbeddedCacheManager)this.cacheManager);
                this.counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager);
                future.complete();
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, false, resultHandler);
    }

    private ClassLoader getCTCCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            if (!this.active) {
                future.complete();
                return;
            }
            this.active = false;
            this.cacheManager.removeListener((Object)this.viewListener);
            if (!this.userProvidedCacheManager) {
                this.cacheManager.stop();
            }
            future.complete();
        }, false, resultHandler);
    }

    public boolean isActive() {
        return this.active;
    }

    @Listener(sync=false)
    private class ClusterViewListener {
        private ClusterViewListener() {
        }

        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            this.handleViewChangeInternal(e);
        }

        @Merged
        public void handleMerge(MergeEvent e) {
            this.handleViewChangeInternal((ViewChangedEvent)e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleViewChangeInternal(ViewChangedEvent e) {
            InfinispanClusterManager infinispanClusterManager = InfinispanClusterManager.this;
            synchronized (infinispanClusterManager) {
                if (!InfinispanClusterManager.this.active) {
                    return;
                }
                InfinispanClusterManager.this.multimaps.forEach(InfinispanAsyncMultiMap::clearCache);
                ArrayList added = new ArrayList(e.getNewMembers());
                added.removeAll(e.getOldMembers());
                log.debug((Object)("Members added = " + added));
                added.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeAdded(address.toString());
                    }
                });
                ArrayList removed = new ArrayList(e.getOldMembers());
                removed.removeAll(e.getNewMembers());
                log.debug((Object)("Members removed = " + removed));
                removed.forEach(address -> {
                    if (InfinispanClusterManager.this.nodeListener != null) {
                        InfinispanClusterManager.this.nodeListener.nodeLeft(address.toString());
                    }
                });
            }
        }
    }
}

