/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.cluster.infinispan.InfinispanAsyncMap;
import io.vertx.ext.cluster.infinispan.impl.CloseableIteratorCollectionStream;
import io.vertx.ext.cluster.infinispan.impl.DataConverter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableSupplier;

public class InfinispanAsyncMapImpl<K, V>
implements AsyncMap<K, V>,
InfinispanAsyncMap<K, V> {
    private final Vertx vertx;
    private final AdvancedCache<Object, Object> cache;

    public InfinispanAsyncMapImpl(Vertx vertx, Cache<Object, Object> cache) {
        this.vertx = vertx;
        this.cache = cache.getAdvancedCache();
    }

    private <T> void whenComplete(CompletableFuture<T> completableFuture, Promise<T> future) {
        Context context = this.vertx.getOrCreateContext();
        completableFuture.whenComplete((v, t) -> {
            if (t != null) {
                context.runOnContext(h -> future.fail(t));
            } else {
                context.runOnContext(h -> future.complete(v));
            }
        });
    }

    public void get(K k, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.getAsync(kk), vertxPromise);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map((Object)null).setHandler(completionHandler);
        this.whenComplete(this.cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync(kk, vv), vertxPromise);
    }

    public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map((Object)null).setHandler(completionHandler);
        this.whenComplete(this.cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync(kk, vv, ttl, TimeUnit.MILLISECONDS), vertxPromise);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map(DataConverter::fromCachedObject).setHandler(completionHandler);
        this.whenComplete(this.cache.putIfAbsentAsync(kk, vv), vertxPromise);
    }

    public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> completionHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map(DataConverter::fromCachedObject).setHandler(completionHandler);
        this.whenComplete(this.cache.putIfAbsentAsync(kk, vv, ttl, TimeUnit.MILLISECONDS), vertxPromise);
    }

    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.removeAsync(kk), vertxPromise);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().setHandler(resultHandler);
        this.whenComplete(this.cache.removeAsync(kk, vv), vertxPromise);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object vv = DataConverter.toCachedObject(v);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().map(DataConverter::fromCachedObject).setHandler(resultHandler);
        this.whenComplete(this.cache.replaceAsync(kk, vv), vertxPromise);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        Object kk = DataConverter.toCachedObject(k);
        Object oo = DataConverter.toCachedObject(oldValue);
        Object nn = DataConverter.toCachedObject(newValue);
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().setHandler(resultHandler);
        this.whenComplete(this.cache.replaceAsync(kk, oo, nn), vertxPromise);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        Promise vertxPromise = Promise.promise();
        vertxPromise.future().setHandler(resultHandler);
        this.whenComplete(this.cache.clearAsync(), vertxPromise);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.vertx.executeBlocking(future -> future.complete((Object)this.cache.size()), false, resultHandler);
    }

    public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            Set cacheKeys = (Set)this.cache.keySet().stream().collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.toSet()));
            future.complete(cacheKeys.stream().map(DataConverter::fromCachedObject).collect(Collectors.toSet()));
        }, false, resultHandler);
    }

    public void values(Handler<AsyncResult<List<V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            List cacheValues = (List)this.cache.values().stream().collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.toList()));
            future.complete(cacheValues.stream().map(DataConverter::fromCachedObject).collect(Collectors.toList()));
        }, false, resultHandler);
    }

    public void entries(Handler<AsyncResult<Map<K, V>>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            Map cacheEntries = (Map)this.cache.entrySet().stream().collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            HashMap result = new HashMap();
            for (Map.Entry entry : cacheEntries.entrySet()) {
                Object k = DataConverter.fromCachedObject(entry.getKey());
                Object v = DataConverter.fromCachedObject(entry.getValue());
                result.put(k, v);
            }
            future.complete(result);
        }, false, resultHandler);
    }

    @Override
    public ReadStream<K> keyStream() {
        return new CloseableIteratorCollectionStream<Object, Object>(this.vertx.getOrCreateContext(), () -> this.cache.keySet(), DataConverter::fromCachedObject);
    }

    @Override
    public ReadStream<V> valueStream() {
        return new CloseableIteratorCollectionStream<Object, Object>(this.vertx.getOrCreateContext(), () -> this.cache.values(), DataConverter::fromCachedObject);
    }

    @Override
    public ReadStream<Map.Entry<K, V>> entryStream() {
        return new CloseableIteratorCollectionStream<Map.Entry, Map.Entry>(this.vertx.getOrCreateContext(), () -> this.cache.entrySet(), cacheEntry -> {
            Object key = DataConverter.fromCachedObject(cacheEntry.getKey());
            Object value = DataConverter.fromCachedObject(cacheEntry.getValue());
            return new AbstractMap.SimpleImmutableEntry(key, value);
        });
    }
}

