/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.WrappedClusterManager;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.health.Health;
import org.infinispan.health.HealthStatus;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;

public class Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);

    public static void close(List<Vertx> clustered) throws Exception {
        for (Vertx vertx : clustered) {
            VertxInternal vertxInternal = (VertxInternal)vertx;
            InfinispanClusterManager clusterManager = Lifecycle.getInfinispanClusterManager(vertxInternal.getClusterManager());
            ComponentStatus status = null;
            if (clusterManager != null) {
                EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)clusterManager.getCacheContainer();
                status = cacheManager.getStatus();
                Health health = cacheManager.getHealth();
                TimeUnit.SECONDS.sleep(2L);
                long start = System.currentTimeMillis();
                try {
                    while (health.getClusterHealth().getHealthStatus() != HealthStatus.HEALTHY && System.currentTimeMillis() - start < TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES)) {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (status == null || status.compareTo((Enum)ComponentStatus.STOPPING) >= 0) {
                vertxInternal.close();
                continue;
            }
            CountDownLatch latch = new CountDownLatch(1);
            vertxInternal.close(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to shutdown vert.x", ar.cause());
                }
                latch.countDown();
            });
            latch.await(2L, TimeUnit.MINUTES);
        }
    }

    private static InfinispanClusterManager getInfinispanClusterManager(ClusterManager cm) {
        if (cm == null) {
            return null;
        }
        if (cm instanceof WrappedClusterManager) {
            return Lifecycle.getInfinispanClusterManager(((WrappedClusterManager)cm).getDelegate());
        }
        if (cm instanceof InfinispanClusterManager) {
            return (InfinispanClusterManager)cm;
        }
        throw new ClassCastException("Unexpected cluster manager implementation: " + cm.getClass());
    }

    private Lifecycle() {
    }
}

