/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.FaultToleranceTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class InfinispanFaultToleranceTest
extends FaultToleranceTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public void setUp() throws Exception {
        System.setProperty("jgroups.file.location", this.temporaryFolder.newFolder().getAbsolutePath());
        super.setUp();
    }

    protected void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> ar) {
        CountDownLatch latch = new CountDownLatch(1);
        Promise promise = Promise.promise();
        promise.future().onComplete(ar);
        super.clusteredVertx(options, asyncResult -> {
            if (asyncResult.succeeded()) {
                promise.complete(asyncResult.result());
            } else {
                promise.fail(asyncResult.cause());
            }
            latch.countDown();
        });
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    protected ClusterManager getClusterManager() {
        return new InfinispanClusterManager();
    }

    protected List<String> getExternalNodeSystemProperties() {
        return Arrays.asList("-Djava.net.preferIPv4Stack=true", "-Djgroups.join_timeout=1000", "-Dvertx.infinispan.config=infinispan.xml", "-Dvertx.jgroups.config=jgroups.xml", "-Djgroups.file.location=" + System.getProperty("jgroups.file.location"), "-Dvertx.logger-delegate-factory-class-name=io.vertx.core.logging.SLF4JLogDelegateFactory");
    }

    protected void afterNodesKilled() throws Exception {
        super.afterNodesKilled();
        Thread.sleep(30000L);
    }
}

