/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.cluster.infinispan;

import io.vertx.Lifecycle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.cluster.infinispan.ClusterHealthCheck;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import io.vertx.test.core.VertxTestBase;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.infinispan.health.HealthStatus;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ClusterHealthCheckTest
extends VertxTestBase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public void setUp() throws Exception {
        System.setProperty("jgroups.file.location", this.temporaryFolder.newFolder().getAbsolutePath());
        super.setUp();
    }

    protected void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> ar) {
        CountDownLatch latch = new CountDownLatch(1);
        Promise promise = Promise.promise();
        promise.future().onComplete(ar);
        super.clusteredVertx(options, asyncResult -> {
            if (asyncResult.succeeded()) {
                promise.complete(asyncResult.result());
            } else {
                promise.fail(asyncResult.cause());
            }
            latch.countDown();
        });
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    protected ClusterManager getClusterManager() {
        return new InfinispanClusterManager();
    }

    protected void close(List<Vertx> clustered) throws Exception {
        Lifecycle.close(clustered);
    }

    @Test
    public void testDetailedHealthCheck() {
        this.startNodes(2);
        ClusterHealthCheck healthCheck = ClusterHealthCheck.createProcedure((Vertx)this.vertices[1], (boolean)true);
        this.vertices[0].sharedData().getAsyncMap("foo", this.onSuccess(asyncMap -> this.vertices[1].executeBlocking((Handler)healthCheck, this.onSuccess(status -> {
            JsonObject json = new JsonObject(status.toJson().encode());
            this.assertTrue(json.getBoolean("ok"));
            this.assertEquals(2, json.getJsonObject("data").getJsonObject("clusterHealth").getInteger("numberOfNodes"));
            String fooCacheHealth = json.getJsonObject("data").getJsonArray("cacheHealth").stream().map(JsonObject.class::cast).filter(entry -> entry.getString("cacheName").equals("foo")).findAny().map(jsonObject -> jsonObject.getString("status")).orElseThrow(() -> new AssertionError((Object)"foo cache is missing"));
            this.assertThat(fooCacheHealth, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)HealthStatus.HEALTHY.name()), (Matcher)CoreMatchers.is((Object)HealthStatus.HEALTHY_REBALANCING.name())));
            this.testComplete();
        }))));
        this.await();
    }
}

