/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.uring;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringChannelOption;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.transport.Transport;
import java.util.concurrent.ThreadFactory;

public class IOUringTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    public boolean supportsDomainSockets() {
        return false;
    }

    public boolean supportFileRegion() {
        return false;
    }

    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            throw new IllegalArgumentException("Domain socket not supported by IOUring transport");
        }
        return super.convert(address);
    }

    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    public boolean isAvailable() {
        return IOUring.isAvailable();
    }

    public Throwable unavailabilityCause() {
        return IOUring.unavailabilityCause();
    }

    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ignoredIoRatio) {
        IOUringEventLoopGroup eventLoopGroup = new IOUringEventLoopGroup(nThreads, threadFactory);
        return eventLoopGroup;
    }

    public DatagramChannel datagramChannel() {
        return new IOUringDatagramChannel();
    }

    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new IOUringDatagramChannel();
    }

    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IOUringSocketChannel::new;
    }

    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return IOUringServerSocketChannel::new;
    }

    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(IOUringChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        super.configure(channel, options);
    }

    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        bootstrap.option(IOUringChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        if (options.isTcpFastOpen()) {
            bootstrap.option(IOUringChannelOption.TCP_FASTOPEN, (Object)(options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0));
        }
        bootstrap.childOption(IOUringChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.childOption(IOUringChannelOption.TCP_CORK, (Object)options.isTcpCork());
        super.configure(options, false, bootstrap);
    }

    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        if (options.isTcpFastOpen()) {
            bootstrap.option(IOUringChannelOption.TCP_FASTOPEN_CONNECT, (Object)options.isTcpFastOpen());
        }
        bootstrap.option(IOUringChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.option(IOUringChannelOption.TCP_CORK, (Object)options.isTcpCork());
        super.configure(options, false, bootstrap);
    }
}

