/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import io.vertx.resourceadapter.impl.VertxPlatformFactory;
import io.vertx.resourceadapter.inflow.impl.VertxActivation;
import io.vertx.resourceadapter.inflow.impl.VertxActivationSpec;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

@Connector(reauthenticationSupport=false, displayName={"Vert.x Resource Adapter"}, description={"VertxResourceAdapter is the Resource Adapter used to interact with a Vert.x cluster."}, eisType="vertx", transactionSupport=TransactionSupport.TransactionSupportLevel.NoTransaction)
public class VertxResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 1130617878526175034L;
    private static Logger log = Logger.getLogger(VertxResourceAdapter.class.getName());
    private final ConcurrentMap<VertxActivationSpec, VertxActivation> activations = new ConcurrentHashMap<VertxActivationSpec, VertxActivation>();
    private WorkManager workManager;

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        VertxActivation activation = new VertxActivation(this, endpointFactory, (VertxActivationSpec)spec);
        this.activations.put((VertxActivationSpec)spec, activation);
        activation.start();
        log.finest("endpointActivation()");
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        VertxActivation activation = (VertxActivation)this.activations.remove(spec);
        if (activation != null) {
            activation.stop();
        }
        log.finest("endpointDeactivation()");
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        log.finest("sets up configuration.");
        this.workManager = ctx.getWorkManager();
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public void stop() {
        log.finest("stop()");
        this.activations.clear();
        VertxPlatformFactory.instance().closeAllPlatforms();
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        log.finest("getXAResources()");
        return null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertxResourceAdapter other = (VertxResourceAdapter)obj;
        return super.equals(other);
    }
}

