/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.resourceadapter.impl.VertxHolder;
import io.vertx.resourceadapter.impl.VertxPlatformConfiguration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertxPlatformFactory {
    private static final Logger log = Logger.getLogger(VertxPlatformFactory.class.getName());
    private static final VertxPlatformFactory INSTANCE = new VertxPlatformFactory();
    private final Map<String, Vertx> vertxPlatforms = new ConcurrentHashMap<String, Vertx>();
    private final Set<VertxHolder> vertxHolders = new ConcurrentHashSet();

    private VertxPlatformFactory() {
    }

    public static VertxPlatformFactory instance() {
        return INSTANCE;
    }

    public synchronized void getOrCreateVertx(VertxPlatformConfiguration config, VertxListener listener) {
        Vertx vertx = this.vertxPlatforms.get(config.getVertxPlatformIdentifier());
        if (vertx != null) {
            listener.whenReady(vertx);
            return;
        }
        VertxOptions options = new VertxOptions();
        options.setClustered(config.isClustered());
        options.setClusterHost(config.getClusterHost());
        options.setClusterPort(config.getClusterPort().intValue());
        CountDownLatch latch = new CountDownLatch(1);
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            block4: {
                try {
                    if (ar.succeeded()) {
                        log.log(Level.INFO, "Acquired Vert.x platform.");
                        listener.whenReady((Vertx)ar.result());
                        this.vertxPlatforms.put(config.getVertxPlatformIdentifier(), (Vertx)ar.result());
                        break block4;
                    }
                    throw new RuntimeException("Could not acquire Vert.x platform.", ar.cause());
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            if (!latch.await(config.getTimeout(), TimeUnit.MILLISECONDS)) {
                log.log(Level.SEVERE, "Could not acquire Vert.x platform in interval.");
                throw new RuntimeException("Could not acquire Vert.x platform in interval");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addVertxHolder(VertxHolder holder) {
        if (this.vertxPlatforms.containsValue(holder.getVertx())) {
            if (!this.vertxHolders.contains(holder)) {
                log.log(Level.INFO, "Adding Vertx Holder: " + holder);
                this.vertxHolders.add(holder);
            } else {
                log.log(Level.WARNING, "Vertx Holder: " + holder + " has been added already.");
            }
        } else {
            log.log(Level.SEVERE, "Vertx Holder: " + holder + " is out of management.");
        }
    }

    public void removeVertxHolder(VertxHolder holder) {
        if (this.vertxHolders.contains(holder)) {
            log.log(Level.INFO, "Removing Vertx Holder: " + holder);
            this.vertxHolders.remove(holder);
        } else {
            log.log(Level.SEVERE, "Vertx Holder: " + holder + " is out of management.");
        }
    }

    public void stopPlatformManager(VertxPlatformConfiguration config) {
        Vertx vertx = this.vertxPlatforms.get(config.getVertxPlatformIdentifier());
        if (vertx != null && this.isVertxHolded(vertx)) {
            log.log(Level.INFO, "Stopping Vert.x: " + config.getVertxPlatformIdentifier());
            this.vertxPlatforms.remove(config.getVertxPlatformIdentifier());
            this.stopVertx(vertx);
        }
    }

    private boolean isVertxHolded(Vertx vertx) {
        for (VertxHolder holder : this.vertxHolders) {
            if (!vertx.equals(holder.getVertx())) continue;
            return true;
        }
        return false;
    }

    public void closeAllPlatforms() {
        log.log(Level.FINEST, "Closing all Vert.x instances");
        try {
            for (Map.Entry<String, Vertx> entry : this.vertxPlatforms.entrySet()) {
                this.stopVertx(entry.getValue());
            }
            this.vertxPlatforms.clear();
            this.vertxHolders.clear();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error closing Vert.x instance", e.getCause());
        }
    }

    private void stopVertx(Vertx vertx) {
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(ar -> {
            try {
                if (ar.succeeded()) {
                    log.log(Level.INFO, "Closed Vert.x platform");
                } else {
                    log.log(Level.WARNING, "Could not close Vert.x platform.", ar.cause());
                }
            }
            finally {
                latch.countDown();
            }
        });
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                log.log(Level.WARNING, "Could not close Vert.x platform");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface VertxListener {
        public void whenReady(Vertx var1);
    }
}

