/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setCurrentContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static String getSystemProperty(final String propName) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(propName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propName);
            }
        });
    }

    static boolean isExpression(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("${") && string.endsWith("}");
    }

    static String getExpressValue(String key) {
        if (SecurityActions.isExpression(key)) {
            String keyValue = SecurityActions.getSystemProperty(key.substring(2, key.length() - 1));
            return keyValue == null ? key : keyValue;
        }
        return key;
    }
}

