/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import io.vertx.core.Vertx;
import io.vertx.resourceadapter.VertxEventBus;
import io.vertx.resourceadapter.impl.VertxConnectionImpl;
import io.vertx.resourceadapter.impl.VertxHolder;
import io.vertx.resourceadapter.impl.VertxManagedConnectionFactory;
import io.vertx.resourceadapter.impl.VertxManagedConnectionMetaData;
import io.vertx.resourceadapter.impl.VertxPlatformFactory;
import io.vertx.resourceadapter.impl.WrappedEventBus;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class VertxManagedConnection
implements ManagedConnection,
VertxHolder {
    private static final Logger log = Logger.getLogger(VertxManagedConnection.class.getName());
    private PrintWriter logwriter;
    private final VertxManagedConnectionFactory mcf;
    private final List<ConnectionEventListener> listeners = Collections.synchronizedList(new ArrayList(1));
    private VertxConnectionImpl vertxConn;
    private final Vertx vertx;

    public VertxManagedConnection(VertxManagedConnectionFactory mcf, Vertx vertx) throws ResourceException {
        this.mcf = mcf;
        this.vertx = vertx;
        this.logwriter = null;
        this.vertxConn = null;
        VertxPlatformFactory.instance().addVertxHolder(this);
    }

    public VertxManagedConnectionFactory getManagementConnectionFactory() {
        return this.mcf;
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        log.finest("getConnection()");
        this.vertxConn = new VertxConnectionImpl(this);
        return this.vertxConn;
    }

    public void associateConnection(Object connection) throws ResourceException {
        log.finest("associateConnection()");
        if (connection == null) {
            throw new ResourceException("Null connection handle");
        }
        if (!(connection instanceof VertxConnectionImpl)) {
            throw new ResourceException("Wrong connection handle");
        }
        this.vertxConn = (VertxConnectionImpl)connection;
    }

    public void cleanup() throws ResourceException {
        log.finest("cleanup()");
    }

    public void destroy() throws ResourceException {
        log.finest("destroy()");
        VertxPlatformFactory.instance().removeVertxHolder(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        log.finest("addConnectionEventListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        log.finest("removeConnectionEventListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.remove(listener);
    }

    void closeHandle(VertxConnectionImpl handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        for (ConnectionEventListener cel : this.listeners) {
            cel.connectionClosed(event);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        log.finest("getLogWriter()");
        return this.logwriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        log.finest("setLogWriter()");
        this.logwriter = out;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("getLocalTransaction() not supported");
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("getXAResource() not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        log.finest("getMetaData()");
        return new VertxManagedConnectionMetaData();
    }

    VertxEventBus getVertxEventBus() {
        return new WrappedEventBus(this.vertx.eventBus());
    }
}

