/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import java.io.Serializable;

public class VertxPlatformConfiguration
implements Serializable {
    private static final long serialVersionUID = -2647099599010357452L;
    private Integer clusterPort = 0;
    private String clusterHost = "localhost";
    private boolean clustered;
    private Long timeout = 30000L;

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        if (timeout >= 0L) {
            this.timeout = timeout;
        }
    }

    public String toString() {
        String str = this.getVertxPlatformIdentifier();
        if (this.timeout != null) {
            str = str + ":timeout[" + this.timeout + "]";
        }
        return str;
    }

    public String getVertxPlatformIdentifier() {
        return this.getClusterHost() + ":" + this.getClusterPort();
    }

    public Integer getClusterPort() {
        return this.clusterPort == null ? Integer.valueOf(0) : this.clusterPort;
    }

    public void setClusterPort(Integer clusterPort) {
        if (clusterPort != null) {
            this.clusterPort = clusterPort;
        }
    }

    public String getClusterHost() {
        return this.clusterHost;
    }

    public void setClusterHost(String clusterHost) {
        if (clusterHost != null) {
            this.clusterHost = clusterHost.trim();
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterHost == null ? 0 : this.clusterHost.hashCode());
        result = 31 * result + (this.clusterPort == null ? 0 : this.clusterPort.hashCode());
        result = 31 * result + (this.timeout == null ? 0 : this.timeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertxPlatformConfiguration other = (VertxPlatformConfiguration)obj;
        if (this.clusterHost == null ? other.clusterHost != null : !this.clusterHost.equals(other.clusterHost)) {
            return false;
        }
        if (this.clusterPort == null ? other.clusterPort != null : !this.clusterPort.equals(other.clusterPort)) {
            return false;
        }
        if (this.timeout == null) {
            if (other.timeout != null) {
                return false;
            }
        } else {
            if (!this.timeout.equals(other.timeout)) {
                return false;
            }
            if (this.clustered != other.isClustered()) {
                return false;
            }
        }
        return true;
    }
}

