/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.inflow.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.resourceadapter.impl.VertxHolder;
import io.vertx.resourceadapter.impl.VertxPlatformConfiguration;
import io.vertx.resourceadapter.impl.VertxPlatformFactory;
import io.vertx.resourceadapter.impl.VertxResourceAdapter;
import io.vertx.resourceadapter.inflow.VertxListener;
import io.vertx.resourceadapter.inflow.impl.VertxActivationSpec;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;

public class VertxActivation<T>
implements VertxPlatformFactory.VertxListener,
VertxHolder {
    private static final Logger log = Logger.getLogger(VertxActivation.class.getName());
    private final VertxResourceAdapter ra;
    private final VertxActivationSpec spec;
    private final MessageEndpointFactory endpointFactory;
    private final VertxPlatformConfiguration config;
    private Handler<Message<Object>> messageHandler;
    private final AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private Vertx vertx;

    public VertxActivation(VertxResourceAdapter ra, MessageEndpointFactory endpointFactory, VertxActivationSpec spec) throws ResourceException {
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        this.config = spec.getVertxPlatformConfig();
    }

    public VertxActivationSpec getActivationSpec() {
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        return this.endpointFactory;
    }

    public void start() throws ResourceException {
        if (!this.deliveryActive.get()) {
            VertxPlatformFactory.instance().getOrCreateVertx(this.config, this);
            VertxPlatformFactory.instance().addVertxHolder(this);
        }
        this.setup();
    }

    private void setup() {
        String address = this.spec.getAddress();
        try {
            MessageEndpoint endPoint = this.endpointFactory.createEndpoint(null);
            this.messageHandler = message -> this.handleMessage(endPoint, (Message<?>)message);
            if (this.vertx == null) {
                throw new ResourceException("Vertx platform did not start yet.");
            }
            this.vertx.eventBus().consumer(address).handler(this.messageHandler);
            log.log(Level.INFO, "Endpoint created, register Vertx handler on address: " + address);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create the endpoint.", e);
        }
    }

    private void handleMessage(MessageEndpoint endPoint, Message<?> message) {
        try {
            this.ra.getWorkManager().scheduleWork((Work)new HandleMessage(endPoint, message));
        }
        catch (WorkException e) {
            throw new RuntimeException("Can't handle message.", e);
        }
    }

    @Override
    public void whenReady(Vertx vertx) {
        if (this.deliveryActive.get()) {
            log.log(Level.WARNING, "Vertx has been started.");
            return;
        }
        this.vertx = vertx;
        this.setup();
        this.deliveryActive.set(true);
        VertxPlatformFactory.instance().addVertxHolder(this);
    }

    @Override
    public Vertx getVertx() {
        return this.vertx;
    }

    public void stop() {
        this.tearDown();
        this.deliveryActive.set(false);
    }

    private void tearDown() {
        VertxPlatformFactory.instance().removeVertxHolder(this);
        VertxPlatformFactory.instance().stopPlatformManager(this.config);
    }

    static {
        try {
            VertxListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class HandleMessage
    implements Work {
        private final MessageEndpoint endPoint;
        private final Message<?> message;

        private HandleMessage(MessageEndpoint endPoint, Message<?> message) {
            this.endPoint = endPoint;
            this.message = message;
        }

        public void run() {
            ((VertxListener)this.endPoint).onMessage(this.message);
        }

        public void release() {
        }
    }
}

