/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.jdbc.impl.actions.JDBCAutoCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCClose;
import io.vertx.ext.jdbc.impl.actions.JDBCCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCExecute;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCRollback;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;

class JDBCConnectionImpl
implements SQLConnection {
    private static final Logger log = LoggerFactory.getLogger(JDBCConnectionImpl.class);
    private final Vertx vertx;
    private final Connection conn;

    public JDBCConnectionImpl(Vertx vertx, Connection conn) {
        this.vertx = vertx;
        this.conn = conn;
    }

    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCAutoCommit(this.vertx, this.conn, autoCommit).execute(resultHandler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCExecute(this.vertx, this.conn, sql).execute(resultHandler);
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.conn, sql, null).execute(resultHandler);
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.conn, sql, params).execute(resultHandler);
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.conn, sql, null).execute(resultHandler);
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.conn, sql, params).execute(resultHandler);
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        new JDBCClose(this.vertx, this.conn).execute(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                log.error((Object)"Failure in closing connection", ar.cause());
            }
        }));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        new JDBCCommit(this.vertx, this.conn).execute(handler);
        return this;
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        new JDBCRollback(this.vertx, this.conn).execute(handler);
        return this;
    }
}

