/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractJDBCAction<T>
implements Handler<Future<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCAction.class);
    protected final Vertx vertx;
    protected final Connection conn;

    protected AbstractJDBCAction(Vertx vertx, Connection conn) {
        this.vertx = vertx;
        this.conn = conn;
    }

    public void handle(Future<T> future) {
        try {
            T result = this.execute(this.conn);
            future.complete(result);
        }
        catch (SQLException e) {
            future.fail((Throwable)e);
        }
    }

    public void execute(Handler<AsyncResult<T>> resultHandler) {
        this.vertx.executeBlocking((Handler)this, resultHandler);
    }

    protected abstract T execute(Connection var1) throws SQLException;

    protected abstract String name();

    protected static void safeClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

