/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.sql.ResultSet;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public abstract class AbstractJDBCStatement<T>
extends AbstractJDBCAction<T> {
    private final String sql;
    private final JsonArray parameters;

    protected AbstractJDBCStatement(Vertx vertx, Connection connection, String sql, JsonArray parameters) {
        super(vertx, connection);
        this.sql = sql;
        this.parameters = parameters;
    }

    @Override
    protected final T execute(Connection conn) throws SQLException {
        try (PreparedStatement statement = this.preparedStatement(conn, this.sql);){
            this.fillStatement(statement, this.parameters);
            T t = this.executeStatement(statement);
            return t;
        }
    }

    protected PreparedStatement preparedStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected abstract T executeStatement(PreparedStatement var1) throws SQLException;

    protected void fillStatement(PreparedStatement statement, JsonArray parameters) throws SQLException {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            statement.setObject(i + 1, parameters.getValue(i));
        }
    }

    protected ResultSet asList(java.sql.ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        ArrayList<JsonArray> results = new ArrayList<JsonArray>();
        while (rs.next()) {
            JsonArray result = new JsonArray();
            for (int i = 1; i <= cols; ++i) {
                Object res = this.convertSqlValue(rs.getObject(i));
                if (res != null) {
                    result.add(res);
                    continue;
                }
                result.addNull();
            }
            results.add(result);
        }
        return new ResultSet(columnNames, results);
    }

    protected Object convertSqlValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Date || value instanceof Time || value instanceof Timestamp) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String tmp = c.getSubString(1L, (int)c.length());
                c.free();
                return tmp;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] tmp = b.getBytes(1L, (int)b.length());
                b.free();
                return tmp;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof Array) {
            Array a = (Array)value;
            try {
                Object[] arr = (Object[])a.getArray();
                if (arr != null) {
                    JsonArray jsonArray = new JsonArray();
                    for (Object o : arr) {
                        jsonArray.add(this.convertSqlValue(o));
                    }
                    a.free();
                    return jsonArray;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return value.toString();
    }
}

