/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCStatement;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCUpdate
extends AbstractJDBCStatement<UpdateResult> {
    public JDBCUpdate(Vertx vertx, Connection connection, String sql, JsonArray parameters) {
        super(vertx, connection, sql, parameters);
    }

    @Override
    protected PreparedStatement preparedStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql, 1);
    }

    @Override
    protected UpdateResult executeStatement(PreparedStatement statement) throws SQLException {
        int updated = statement.executeUpdate();
        JsonObject result = new JsonObject();
        result.put("updated", Integer.valueOf(updated));
        ResultSet rs = statement.getGeneratedKeys();
        JsonArray keys = new JsonArray();
        while (rs.next()) {
            keys.add(this.convertSqlValue(rs.getObject(1)));
        }
        rs.close();
        return new UpdateResult(updated, keys);
    }

    @Override
    protected String name() {
        return "update";
    }
}

