/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.jdbc.impl.actions.JDBCAutoCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCBatch;
import io.vertx.ext.jdbc.impl.actions.JDBCCallable;
import io.vertx.ext.jdbc.impl.actions.JDBCClose;
import io.vertx.ext.jdbc.impl.actions.JDBCCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCExecute;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCRollback;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.jdbc.impl.actions.StreamQuery;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class JDBCConnectionImpl
implements SQLConnection {
    private static final Logger log = LoggerFactory.getLogger(JDBCConnectionImpl.class);
    private final Vertx vertx;
    private final Connection conn;
    private final WorkerExecutor executor;
    private final PoolMetrics metrics;
    private final Object metric;
    private final int rowStreamFetchSize;
    private final JDBCStatementHelper helper;
    private int timeout = -1;

    public JDBCConnectionImpl(Context context, JDBCStatementHelper helper, Connection conn, PoolMetrics metrics, Object metric, int rowStreamFetchSize) {
        this.vertx = context.owner();
        this.helper = helper;
        this.conn = conn;
        this.metrics = metrics;
        this.metric = metric;
        this.rowStreamFetchSize = rowStreamFetchSize;
        this.executor = ((ContextInternal)context).createWorkerExecutor();
    }

    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCAutoCommit(this.vertx, this.conn, this.executor, autoCommit).execute(resultHandler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCExecute(this.vertx, this.conn, this.executor, this.timeout, sql).execute(resultHandler);
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, null).execute(resultHandler);
        return this;
    }

    public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        new StreamQuery(this.vertx, this.helper, this.conn, this.executor, this.timeout, this.rowStreamFetchSize, sql, null).execute(handler);
        return this;
    }

    public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        new StreamQuery(this.vertx, this.helper, this.conn, this.executor, this.timeout, this.rowStreamFetchSize, sql, params).execute(handler);
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, params).execute(resultHandler);
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, null).execute(resultHandler);
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, params).execute(resultHandler);
        return this;
    }

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCCallable(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, null, null).execute(resultHandler);
        return this;
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCCallable(this.vertx, this.helper, this.conn, this.executor, this.timeout, sql, params, outputs).execute(resultHandler);
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        if (this.metrics != null) {
            this.metrics.end(this.metric, true);
        }
        new JDBCClose(this.vertx, this.conn, this.executor).execute(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                log.error((Object)"Failure in closing connection", ar.cause());
            }
        }));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        new JDBCCommit(this.vertx, this.conn, this.executor).execute(handler);
        return this;
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        new JDBCRollback(this.vertx, this.conn, this.executor).execute(handler);
        return this;
    }

    public SQLConnection setQueryTimeout(int timeoutInSeconds) {
        this.timeout = timeoutInSeconds;
        return this;
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
        this.executor.executeBlocking(f -> {
            try {
                switch (isolation) {
                    case READ_COMMITTED: {
                        this.conn.setTransactionIsolation(2);
                        break;
                    }
                    case READ_UNCOMMITTED: {
                        this.conn.setTransactionIsolation(1);
                        break;
                    }
                    case REPEATABLE_READ: {
                        this.conn.setTransactionIsolation(4);
                        break;
                    }
                    case SERIALIZABLE: {
                        this.conn.setTransactionIsolation(8);
                        break;
                    }
                    case NONE: {
                        this.conn.setTransactionIsolation(0);
                        break;
                    }
                    default: {
                        log.warn((Object)("Unknown isolation level " + isolation.name()));
                    }
                }
                f.complete();
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, handler);
        return this;
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        this.executor.executeBlocking(f -> {
            try {
                int level = this.conn.getTransactionIsolation();
                switch (level) {
                    case 2: {
                        f.complete((Object)TransactionIsolation.READ_COMMITTED);
                        break;
                    }
                    case 1: {
                        f.complete((Object)TransactionIsolation.READ_UNCOMMITTED);
                        break;
                    }
                    case 4: {
                        f.complete((Object)TransactionIsolation.REPEATABLE_READ);
                        break;
                    }
                    case 8: {
                        f.complete((Object)TransactionIsolation.SERIALIZABLE);
                        break;
                    }
                    case 0: {
                        f.complete((Object)TransactionIsolation.NONE);
                        break;
                    }
                    default: {
                        f.fail("Unknown isolation level " + level);
                        break;
                    }
                }
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, handler);
        return this;
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.conn, this.executor, sqlStatements).execute(handler);
        return this;
    }

    public SQLConnection batchWithParams(String statement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.conn, this.executor, statement, args).execute(handler);
        return this;
    }

    public SQLConnection batchCallableWithParams(String statement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.conn, this.executor, statement, inArgs, outArgs).execute(handler);
        return this;
    }
}

