/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.jdbc;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.ext.sql.SQLConnection;
import io.vertx.rxjava.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.rxjava.ext.sql.SQLClient;
import io.vertx.core.Handler;

/**
 * An asynchronous client interface for interacting with a JDBC compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.jdbc.JDBCClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.jdbc.JDBCClient.class)
public class JDBCClient extends SQLClient {

  public static final io.vertx.lang.rxjava.TypeArg<JDBCClient> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new JDBCClient((io.vertx.ext.jdbc.JDBCClient) obj),
    JDBCClient::getDelegate
  );

  private final io.vertx.ext.jdbc.JDBCClient delegate;
  
  public JDBCClient(io.vertx.ext.jdbc.JDBCClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.jdbc.JDBCClient getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static JDBCClient createNonShared(Vertx vertx, JsonObject config) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a JDBC client which shares its data source with any other JDBC clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static JDBCClient createShared(Vertx vertx, JsonObject config, String dataSourceName) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.ext.jdbc.JDBCClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static JDBCClient createShared(Vertx vertx, JsonObject config) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config));
    return ret;
  }


  public static  JDBCClient newInstance(io.vertx.ext.jdbc.JDBCClient arg) {
    return arg != null ? new JDBCClient(arg) : null;
  }
}
