/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLRowStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class JDBCSQLRowStream
implements SQLRowStream {
    private static final Logger log = LoggerFactory.getLogger(JDBCSQLRowStream.class);
    private final ContextInternal ctx;
    private final TaskQueue statementsQueue;
    private final Statement st;
    private final int fetchSize;
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final AtomicBoolean ended = new AtomicBoolean(false);
    private final AtomicBoolean stClosed = new AtomicBoolean(false);
    private final AtomicBoolean rsClosed = new AtomicBoolean(false);
    private final AtomicBoolean more = new AtomicBoolean(false);
    private final Deque<JsonArray> accumulator;
    private ResultSet rs;
    private ResultSetMetaData metaData;
    private List<String> columns;
    private int cols;
    private Handler<Throwable> exceptionHandler;
    private Handler<JsonArray> handler;
    private Handler<Void> endHandler;
    private Handler<Void> rsClosedHandler;

    JDBCSQLRowStream(ContextInternal ctx, TaskQueue statementsQueue, Statement st, ResultSet rs, int fetchSize) throws SQLException {
        this.ctx = ctx;
        this.st = st;
        this.fetchSize = fetchSize;
        this.rs = rs;
        this.statementsQueue = statementsQueue;
        this.accumulator = new ArrayDeque<JsonArray>(fetchSize);
        this.metaData = rs.getMetaData();
        this.cols = this.metaData.getColumnCount();
        this.paused.set(true);
        this.stClosed.set(false);
        this.rsClosed.set(false);
        this.more.set(true);
    }

    public int column(String name) {
        try {
            return this.rs.findColumn(name) - 1;
        }
        catch (SQLException e) {
            return -1;
        }
    }

    public List<String> columns() {
        if (this.columns == null) {
            try {
                if (this.cols > 0) {
                    ArrayList<String> columns = new ArrayList<String>(this.cols);
                    for (int i = 0; i < this.cols; ++i) {
                        columns.add(i, this.metaData.getColumnName(i + 1));
                    }
                    this.columns = Collections.unmodifiableList(columns);
                } else {
                    this.columns = Collections.emptyList();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.columns;
    }

    public SQLRowStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public SQLRowStream handler(Handler<JsonArray> handler) {
        this.handler = handler;
        this.resume();
        return this;
    }

    public SQLRowStream pause() {
        this.paused.compareAndSet(false, true);
        return this;
    }

    public SQLRowStream resume() {
        if (this.paused.compareAndSet(true, false)) {
            this.nextRow();
        }
        return this;
    }

    private void nextRow() {
        if (!this.paused.get()) {
            while (!this.paused.get() && !this.accumulator.isEmpty()) {
                this.handler.handle((Object)this.accumulator.pollFirst());
            }
        }
        if (!this.paused.get()) {
            this.ctx.executeBlocking(this::readRows, this.statementsQueue, res -> {
                if (res.failed()) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)res.cause());
                    } else {
                        log.debug((Object)res.cause());
                    }
                } else if (this.accumulator.isEmpty()) {
                    this.ended.set(true);
                    if (this.rsClosedHandler != null) {
                        this.close0((Handler<AsyncResult<Void>>)((Handler)c -> {
                            if (res.failed()) {
                                if (this.exceptionHandler != null) {
                                    this.exceptionHandler.handle((Object)res.cause());
                                } else {
                                    log.debug((Object)res.cause());
                                }
                            } else {
                                this.rsClosedHandler.handle(null);
                            }
                        }));
                    } else {
                        this.close((Handler<AsyncResult<Void>>)((Handler)c -> {
                            if (res.failed()) {
                                if (this.exceptionHandler != null) {
                                    this.exceptionHandler.handle((Object)res.cause());
                                } else {
                                    log.debug((Object)res.cause());
                                }
                            } else if (this.endHandler != null) {
                                this.endHandler.handle(null);
                            }
                        }));
                    }
                } else {
                    this.nextRow();
                }
            });
        }
    }

    private void readRows(Future<Void> fut) {
        try {
            while (this.accumulator.size() < this.fetchSize && this.rs.next()) {
                JsonArray result = new JsonArray();
                for (int i = 1; i <= this.cols; ++i) {
                    Object res = JDBCStatementHelper.convertSqlValue(this.rs.getObject(i));
                    if (res != null) {
                        result.add(res);
                        continue;
                    }
                    result.addNull();
                }
                this.accumulator.add(result);
            }
            this.paused.compareAndSet(false, false);
            fut.complete();
        }
        catch (SQLException e) {
            fut.fail((Throwable)e);
        }
    }

    public SQLRowStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        if (this.ended.compareAndSet(true, false) && this.endHandler != null) {
            this.endHandler.handle(null);
        }
        return this;
    }

    private void close0(Handler<AsyncResult<Void>> handler) {
        this.pause();
        this.close(this.rs, this.rsClosed, handler);
    }

    public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.close0((Handler<AsyncResult<Void>>)((Handler)res -> this.close(this.st, this.stClosed, handler)));
    }

    public SQLRowStream resultSetClosedHandler(Handler<Void> handler) {
        this.rsClosedHandler = handler;
        return this;
    }

    public void moreResults() {
        if (this.more.compareAndSet(true, false)) {
            this.pause();
            this.ctx.executeBlocking(this::getNextResultSet, this.statementsQueue, res -> {
                if (res.failed()) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)res.cause());
                    } else {
                        log.debug((Object)res.cause());
                    }
                } else if (this.more.get()) {
                    this.resume();
                } else if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            });
        }
    }

    private void getNextResultSet(Future<Void> f) {
        try {
            if (this.rsClosed.compareAndSet(false, true)) {
                this.rs.close();
            }
            if (this.st.getMoreResults()) {
                this.rs = this.st.getResultSet();
                this.metaData = this.rs.getMetaData();
                this.cols = this.metaData.getColumnCount();
                this.columns = null;
                this.paused.set(true);
                this.stClosed.set(false);
                this.rsClosed.set(false);
                this.more.set(true);
            }
            f.complete();
        }
        catch (SQLException e) {
            f.fail((Throwable)e);
        }
    }

    private void close(AutoCloseable closeable, AtomicBoolean lock, Handler<AsyncResult<Void>> handler) {
        if (lock.compareAndSet(false, true)) {
            this.ctx.executeBlocking(f -> {
                try {
                    closeable.close();
                    f.complete();
                }
                catch (Exception e) {
                    f.fail((Throwable)e);
                }
            }, this.statementsQueue, handler);
        } else if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }
}

