/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JDBCUpdate
extends AbstractJDBCAction<UpdateResult> {
    private final String sql;
    private final JsonArray in;
    private boolean generateKeys;

    public JDBCUpdate(Vertx vertx, JDBCStatementHelper helper, SQLOptions options, ContextInternal ctx, String sql, JsonArray in) {
        super(vertx, helper, options, ctx);
        this.sql = sql;
        this.in = in;
    }

    private PreparedStatement prepareStatement(Connection conn) throws SQLException {
        if (this.options != null) {
            if (this.options.isAutoGeneratedKeys() && this.options.getAutoGeneratedKeysIndexes() == null) {
                this.generateKeys = true;
                return conn.prepareStatement(this.sql, 1);
            }
            if (this.options.getAutoGeneratedKeysIndexes() != null) {
                if (this.options.getAutoGeneratedKeysIndexes().getValue(0) instanceof String) {
                    String[] columnNames = new String[this.options.getAutoGeneratedKeysIndexes().size()];
                    for (int i = 0; i < columnNames.length; ++i) {
                        columnNames[i] = this.options.getAutoGeneratedKeysIndexes().getString(i);
                    }
                    this.generateKeys = true;
                    return conn.prepareStatement(this.sql, columnNames);
                }
                if (this.options.getAutoGeneratedKeysIndexes().getValue(0) instanceof Integer) {
                    int[] columnIndexes = new int[this.options.getAutoGeneratedKeysIndexes().size()];
                    for (int i = 0; i < columnIndexes.length; ++i) {
                        columnIndexes[i] = this.options.getAutoGeneratedKeysIndexes().getInteger(i);
                    }
                    this.generateKeys = true;
                    return conn.prepareStatement(this.sql, columnIndexes);
                }
                throw new SQLException("Invalid type for auto generated keys");
            }
        }
        this.generateKeys = false;
        return conn.prepareStatement(this.sql, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResult execute(Connection conn) throws SQLException {
        try (PreparedStatement statement = this.prepareStatement(conn);){
            this.applyStatementOptions(statement);
            this.helper.fillStatement(statement, this.in);
            int updated = statement.executeUpdate();
            JsonArray keys = new JsonArray();
            if (this.generateKeys) {
                ResultSet rs = null;
                try {
                    rs = statement.getGeneratedKeys();
                    if (rs != null) {
                        int columns;
                        ResultSetMetaData metaData = rs.getMetaData();
                        int n = columns = metaData != null ? metaData.getColumnCount() : 1;
                        while (rs.next()) {
                            for (int i = 1; i <= columns; ++i) {
                                Object key = rs.getObject(i);
                                if (key == null) {
                                    keys.addNull();
                                    continue;
                                }
                                keys.add(JDBCStatementHelper.convertSqlValue(key));
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            UpdateResult updateResult = new UpdateResult(updated, keys);
            return updateResult;
        }
    }

    @Override
    protected String name() {
        return "update";
    }
}

