/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.jdbc;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.ResultSet;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.core.Handler;
import io.vertx.reactivex.ext.sql.SQLOperations;

/**
 * An asynchronous client interface for interacting with a JDBC compliant database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.jdbc.JDBCClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.jdbc.JDBCClient.class)
public class JDBCClient extends SQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCClient that = (JDBCClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<JDBCClient> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new JDBCClient((io.vertx.ext.jdbc.JDBCClient) obj),
    JDBCClient::getDelegate
  );

  private final io.vertx.ext.jdbc.JDBCClient delegate;
  
  public JDBCClient(io.vertx.ext.jdbc.JDBCClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.jdbc.JDBCClient getDelegate() {
    return delegate;
  }

  public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  public Single<JsonArray> rxQuerySingle(String sql) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingle(sql, handler);
    });
  }

  public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      querySingleWithParams(sql, arguments, handler);
    });
  }

  /**
   * Create a JDBC client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static JDBCClient createNonShared(Vertx vertx, JsonObject config) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createNonShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a JDBC client which shares its data source with any other JDBC clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static JDBCClient createShared(Vertx vertx, JsonObject config, String dataSourceName) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.jdbc.JDBCClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static JDBCClient createShared(Vertx vertx, JsonObject config) { 
    JDBCClient ret = JDBCClient.newInstance(io.vertx.ext.jdbc.JDBCClient.createShared(vertx.getDelegate(), config));
    return ret;
  }


  public static  JDBCClient newInstance(io.vertx.ext.jdbc.JDBCClient arg) {
    return arg != null ? new JDBCClient(arg) : null;
  }
}
