/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.jdbc.impl.actions.JDBCAutoCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCBatch;
import io.vertx.ext.jdbc.impl.actions.JDBCCallable;
import io.vertx.ext.jdbc.impl.actions.JDBCClose;
import io.vertx.ext.jdbc.impl.actions.JDBCCommit;
import io.vertx.ext.jdbc.impl.actions.JDBCExecute;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCRollback;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.jdbc.impl.actions.StreamQuery;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

class JDBCConnectionImpl
implements SQLConnection {
    static final Logger log = LoggerFactory.getLogger(JDBCConnectionImpl.class);
    private final Vertx vertx;
    final Connection conn;
    private final ContextInternal ctx;
    final PoolMetrics metrics;
    final Object metric;
    private final TaskQueue statementsQueue = new TaskQueue();
    private final JDBCStatementHelper helper;
    private SQLOptions options;

    public JDBCConnectionImpl(Context context, JDBCStatementHelper helper, Connection conn, PoolMetrics metrics, Object metric) {
        this.vertx = context.owner();
        this.helper = helper;
        this.conn = conn;
        this.metrics = metrics;
        this.metric = metric;
        this.ctx = (ContextInternal)context;
    }

    public SQLConnection setOptions(SQLOptions options) {
        this.options = options;
        return this;
    }

    public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCAutoCommit(this.vertx, this.options, this.ctx, autoCommit).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
        new JDBCExecute(this.vertx, this.options, this.ctx, sql).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.helper, this.options, this.ctx, sql, null).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        new StreamQuery(this.vertx, this.helper, this.options, this.ctx, this.statementsQueue, sql, null).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        new StreamQuery(this.vertx, this.helper, this.options, this.ctx, this.statementsQueue, sql, params).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCQuery(this.vertx, this.helper, this.options, this.ctx, sql, params).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.helper, this.options, this.ctx, sql, null).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
        new JDBCUpdate(this.vertx, this.helper, this.options, this.ctx, sql, params).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCCallable(this.vertx, this.helper, this.options, this.ctx, sql, null, null).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
        new JDBCCallable(this.vertx, this.helper, this.options, this.ctx, sql, params, outputs).execute(this.conn, this.statementsQueue, resultHandler);
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        new JDBCClose(this.vertx, this.options, this.ctx, this.metrics, this.metric).execute(this.conn, this.statementsQueue, handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                log.error((Object)"Failure in closing connection", ar.cause());
            }
        }));
    }

    public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
        new JDBCCommit(this.vertx, this.options, this.ctx).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
        new JDBCRollback(this.vertx, this.options, this.ctx).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
        this.ctx.executeBlocking(f -> {
            try {
                TransactionIsolation txIsolation = TransactionIsolation.from((int)this.conn.getTransactionIsolation());
                if (txIsolation != null) {
                    f.complete((Object)txIsolation);
                } else {
                    f.fail("Unknown isolation level");
                }
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.options, this.ctx, sqlStatements).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection batchWithParams(String statement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.options, this.ctx, statement, args).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection batchCallableWithParams(String statement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
        new JDBCBatch(this.vertx, this.helper, this.options, this.ctx, statement, inArgs, outArgs).execute(this.conn, this.statementsQueue, handler);
        return this;
    }

    public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
        this.ctx.executeBlocking(f -> {
            try {
                this.conn.setTransactionIsolation(isolation.getType());
                f.complete(null);
            }
            catch (SQLException e) {
                f.fail((Throwable)e);
            }
        }, this.statementsQueue, handler);
        return this;
    }

    public <C> C unwrap() {
        return (C)this.conn;
    }
}

