/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.impl.DataSourceHolder;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class JDBCClientImpl
implements JDBCClient {
    private static final String DS_LOCAL_MAP_NAME = "__vertx.JDBCClient.datasources";
    private final VertxInternal vertx;
    private final String datasourceName;
    private final JsonObject config;
    private final Map<String, DataSourceHolder> holders;
    private final JDBCStatementHelper helper;
    private boolean closed;

    public JDBCClientImpl(Vertx vertx, DataSource dataSource) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(dataSource);
        this.vertx = (VertxInternal)vertx;
        this.datasourceName = UUID.randomUUID().toString();
        this.config = null;
        this.holders = vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
        DataSourceHolder holder = new DataSourceHolder(dataSource, this.createExecutor(), this.createMetrics(this.datasourceName, -1));
        this.holders.put(this.datasourceName, holder);
        this.helper = new JDBCStatementHelper();
        this.setupCloseHook();
    }

    public JDBCClientImpl(Vertx vertx, JsonObject config, String datasourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(datasourceName);
        this.vertx = (VertxInternal)vertx;
        this.datasourceName = datasourceName;
        this.config = config;
        this.holders = vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
        DataSourceProvider provider = this.createProvider();
        this.holders.compute(datasourceName, (k, h) -> h == null ? new DataSourceHolder(provider) : h.increment());
        this.helper = new JDBCStatementHelper(config);
        this.setupCloseHook();
    }

    private void setupCloseHook() {
        Context ctx = Vertx.currentContext();
        if (ctx != null && ctx.owner() == this.vertx) {
            ctx.addCloseHook(this::close);
        }
    }

    public void close() {
        this.close(null);
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.raiseCloseFlag()) {
            while (true) {
                DataSourceHolder current = this.holders.get(this.datasourceName);
                DataSourceHolder next = current.decrement();
                if (next.refCount == 0) {
                    if (!this.holders.remove(this.datasourceName, current)) continue;
                    if (current.dataSource != null) {
                        this.doClose(current, completionHandler);
                        return;
                    }
                    break;
                }
                if (this.holders.replace(this.datasourceName, current, next)) break;
            }
        }
        if (completionHandler != null) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    private synchronized boolean raiseCloseFlag() {
        if (!this.closed) {
            this.closed = true;
            return true;
        }
        return false;
    }

    public JDBCClient update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.executeDirect(ctx, new JDBCUpdate((Vertx)this.vertx, this.helper, null, ctx, sql, null), resultHandler);
        return this;
    }

    public JDBCClient updateWithParams(String sql, JsonArray in, Handler<AsyncResult<UpdateResult>> resultHandler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.executeDirect(ctx, new JDBCUpdate((Vertx)this.vertx, this.helper, null, ctx, sql, in), resultHandler);
        return this;
    }

    public JDBCClient query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.executeDirect(ctx, new JDBCQuery((Vertx)this.vertx, this.helper, null, ctx, sql, null), resultHandler);
        return this;
    }

    public JDBCClient queryWithParams(String sql, JsonArray in, Handler<AsyncResult<ResultSet>> resultHandler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.executeDirect(ctx, new JDBCQuery((Vertx)this.vertx, this.helper, null, ctx, sql, in), resultHandler);
        return this;
    }

    private <T> void executeDirect(ContextInternal ctx, AbstractJDBCAction<T> action, Handler<AsyncResult<T>> handler) {
        this.getConnection(ctx, (Handler<AsyncResult<SQLConnection>>)((Handler)ar1 -> {
            Promise promise = Promise.promise();
            promise.future().setHandler(ar2 -> ctx.runOnContext(v -> handler.handle(ar2)));
            if (ar1.succeeded()) {
                JDBCConnectionImpl conn = (JDBCConnectionImpl)ar1.result();
                try {
                    Object result = action.execute(conn.conn);
                    promise.complete(result);
                }
                catch (Exception e) {
                    promise.fail((Throwable)e);
                }
                finally {
                    if (conn.metrics != null) {
                        conn.metrics.end(conn.metric, true);
                    }
                    try {
                        conn.conn.close();
                    }
                    catch (Exception e) {
                        JDBCConnectionImpl.log.error((Object)"Failure in closing connection", ar1.cause());
                    }
                }
            } else {
                promise.fail(ar1.cause());
            }
        }));
    }

    private void getConnection(ContextInternal ctx, Handler<AsyncResult<SQLConnection>> handler) {
        this.getDataSourceHolder(ctx, (Handler<AsyncResult<DataSourceHolder>>)((Handler)ar -> {
            if (ar.succeeded()) {
                DataSourceHolder holder = (DataSourceHolder)ar.result();
                boolean enabled = holder.metrics != null;
                Object queueMetric = enabled ? holder.metrics.submitted() : null;
                holder.exec.execute(() -> {
                    Promise res = Promise.promise();
                    res.future().setHandler(handler);
                    try {
                        Connection conn = holder.dataSource.getConnection();
                        Object execMetric = enabled ? holder.metrics.begin(queueMetric) : null;
                        res.complete((Object)new JDBCConnectionImpl((Context)ctx, this.helper, conn, holder.metrics, execMetric));
                    }
                    catch (SQLException e) {
                        if (enabled) {
                            holder.metrics.rejected(queueMetric);
                        }
                        res.fail((Throwable)e);
                    }
                });
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        }));
    }

    private synchronized void getDataSourceHolder(ContextInternal ctx, Handler<AsyncResult<DataSourceHolder>> handler) {
        if (this.closed) {
            handler.handle((Object)Future.failedFuture((String)"Client is closed"));
        } else {
            DataSourceHolder holder = this.holders.get(this.datasourceName);
            if (holder.dataSource != null) {
                handler.handle((Object)Future.succeededFuture((Object)holder));
            } else {
                ctx.executeBlocking(promise -> this.createDataSource((Promise<DataSourceHolder>)promise), holder.creationQueue, handler);
            }
        }
    }

    private void createDataSource(Promise<DataSourceHolder> promise) {
        int poolSize;
        DataSource dataSource;
        DataSourceHolder current = this.holders.get(this.datasourceName);
        if (current == null) {
            promise.fail("Client closed while connecting");
            return;
        }
        if (current.dataSource != null) {
            promise.complete((Object)current);
            return;
        }
        DataSourceProvider provider = current.provider;
        try {
            dataSource = provider.getDataSource(this.config);
            poolSize = provider.maximumPoolSize(dataSource, this.config);
        }
        catch (SQLException e) {
            promise.fail((Throwable)e);
            return;
        }
        ExecutorService exec = this.createExecutor();
        PoolMetrics metrics = this.createMetrics(this.datasourceName, poolSize);
        current = this.holders.compute(this.datasourceName, (k, h) -> h == null ? null : h.created(dataSource, exec, metrics));
        if (current != null) {
            promise.complete((Object)current);
        } else {
            if (metrics != null) {
                metrics.close();
            }
            exec.shutdown();
            try {
                provider.close(dataSource);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            promise.fail("Client closed while connecting");
        }
    }

    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.getConnection(ctx, (Handler<AsyncResult<SQLConnection>>)((Handler)ar -> ctx.runOnContext(v -> handler.handle(ar))));
        return this;
    }

    private DataSourceProvider createProvider() {
        String providerClass = this.config.getString("provider_class");
        if (providerClass == null) {
            providerClass = "io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider";
        }
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(providerClass);
                return (DataSourceProvider)clazz.newInstance();
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(providerClass);
            return (DataSourceProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private PoolMetrics createMetrics(String poolName, int maxPoolSize) {
        VertxMetrics metricsSPI = this.vertx.metricsSPI();
        return metricsSPI != null ? metricsSPI.createPoolMetrics("datasource", poolName, maxPoolSize) : null;
    }

    private ExecutorService createExecutor() {
        return new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "vertx-jdbc-service-get-connection-thread"));
    }

    private void doClose(DataSourceHolder holder, Handler<AsyncResult<Void>> completionHandler) {
        if (holder.metrics != null) {
            holder.metrics.close();
        }
        this.vertx.executeBlocking(promise -> {
            try {
                if (holder.provider != null) {
                    holder.provider.close(holder.dataSource);
                }
                promise.complete();
            }
            catch (SQLException e) {
                promise.fail((Throwable)e);
            }
        }, false, ar -> {
            holder.exec.shutdown();
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
        });
    }
}

