/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractJDBCAction<T> {
    protected final Vertx vertx;
    protected final SQLOptions options;
    protected final ContextInternal ctx;
    protected final JDBCStatementHelper helper;

    protected AbstractJDBCAction(Vertx vertx, SQLOptions options, ContextInternal ctx) {
        this(vertx, null, options, ctx);
    }

    protected AbstractJDBCAction(Vertx vertx, JDBCStatementHelper helper, SQLOptions options, ContextInternal ctx) {
        this.vertx = vertx;
        this.options = options;
        this.ctx = ctx;
        this.helper = helper;
    }

    private void handle(Connection conn, Promise<T> future) {
        try {
            this.applyConnectionOptions(conn);
            T result = this.execute(conn);
            future.complete(result);
        }
        catch (SQLException e) {
            future.fail((Throwable)e);
        }
    }

    public void execute(Connection conn, TaskQueue statementsQueue, Handler<AsyncResult<T>> resultHandler) {
        this.ctx.executeBlocking(future -> this.handle(conn, (Promise<T>)future), statementsQueue, resultHandler);
    }

    public abstract T execute(Connection var1) throws SQLException;

    protected abstract String name();

    void applyStatementOptions(Statement statement) throws SQLException {
        if (this.options != null) {
            if (this.options.getQueryTimeout() > 0) {
                statement.setQueryTimeout(this.options.getQueryTimeout());
            }
            if (this.options.getFetchDirection() != null) {
                statement.setFetchDirection(this.options.getFetchDirection().getType());
            }
            if (this.options.getFetchSize() > 0) {
                statement.setFetchSize(this.options.getFetchSize());
            }
        }
    }

    private void applyConnectionOptions(Connection conn) throws SQLException {
        if (this.options != null) {
            if (this.options.isReadOnly()) {
                conn.setReadOnly(true);
            }
            if (this.options.getCatalog() != null) {
                conn.setCatalog(this.options.getCatalog());
            }
            if (this.options.getSchema() != null) {
                conn.setSchema(this.options.getSchema());
            }
        }
    }
}

