/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public class HikariCPDataSourceProvider
implements DataSourceProvider {
    @Override
    public DataSource getDataSource(JsonObject json) throws SQLException {
        HikariConfig config = new HikariConfig();
        for (Map.Entry entry : json) {
            switch ((String)entry.getKey()) {
                case "dataSourceClassName": {
                    config.setDataSourceClassName((String)entry.getValue());
                    break;
                }
                case "jdbcUrl": {
                    config.setJdbcUrl((String)entry.getValue());
                    break;
                }
                case "username": {
                    config.setUsername((String)entry.getValue());
                    break;
                }
                case "password": {
                    config.setPassword((String)entry.getValue());
                    break;
                }
                case "autoCommit": {
                    config.setAutoCommit(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "connectionTimeout": {
                    config.setConnectionTimeout(this.getLong(entry.getValue()));
                    break;
                }
                case "idleTimeout": {
                    config.setIdleTimeout(this.getLong(entry.getValue()));
                    break;
                }
                case "maxLifetime": {
                    config.setMaxLifetime(this.getLong(entry.getValue()));
                    break;
                }
                case "connectionTestQuery": {
                    config.setConnectionTestQuery((String)entry.getValue());
                    break;
                }
                case "minimumIdle": {
                    config.setMinimumIdle(((Integer)entry.getValue()).intValue());
                    break;
                }
                case "maximumPoolSize": {
                    config.setMaximumPoolSize(((Integer)entry.getValue()).intValue());
                    break;
                }
                case "metricRegistry": {
                    throw new UnsupportedOperationException((String)entry.getKey());
                }
                case "healthCheckRegistry": {
                    throw new UnsupportedOperationException((String)entry.getKey());
                }
                case "poolName": {
                    config.setPoolName((String)entry.getValue());
                    break;
                }
                case "isolationInternalQueries": {
                    config.setIsolateInternalQueries(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "allowPoolSuspension": {
                    config.setAllowPoolSuspension(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "readOnly": {
                    config.setReadOnly(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "registerMBeans": {
                    config.setRegisterMbeans(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "catalog": {
                    config.setCatalog((String)entry.getValue());
                    break;
                }
                case "connectionInitSql": {
                    config.setConnectionInitSql((String)entry.getValue());
                    break;
                }
                case "driverClassName": {
                    config.setDriverClassName((String)entry.getValue());
                    break;
                }
                case "transactionIsolation": {
                    config.setTransactionIsolation((String)entry.getValue());
                    break;
                }
                case "validationTimeout": {
                    config.setValidationTimeout(this.getLong(entry.getValue()));
                    break;
                }
                case "leakDetectionThreshold": {
                    config.setLeakDetectionThreshold(this.getLong(entry.getValue()));
                    break;
                }
                case "dataSource": {
                    throw new UnsupportedOperationException((String)entry.getKey());
                }
                case "threadFactory": {
                    throw new UnsupportedOperationException((String)entry.getKey());
                }
                case "datasource": {
                    for (Map.Entry key : (JsonObject)entry.getValue()) {
                        config.addDataSourceProperty((String)key.getKey(), key.getValue());
                    }
                    break;
                }
            }
        }
        return new HikariDataSource(config);
    }

    private long getLong(Object value) {
        if (value.getClass() == Long.class || value.getClass() == Long.TYPE) {
            return (Long)value;
        }
        if (value.getClass() == Integer.class || value.getClass() == Integer.TYPE) {
            return ((Integer)value).intValue();
        }
        throw new IllegalArgumentException("Invalid value to be cast to long: " + value);
    }

    @Override
    public int maximumPoolSize(DataSource dataSource, JsonObject config) throws SQLException {
        if (dataSource instanceof HikariDataSource) {
            return ((HikariDataSource)dataSource).getMaximumPoolSize();
        }
        return -1;
    }

    @Override
    public void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof HikariDataSource) {
            ((HikariDataSource)dataSource).close();
        }
    }
}

