/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractJDBCAction<T> {
    protected final SQLOptions options;
    protected final JDBCStatementHelper helper;

    protected AbstractJDBCAction(SQLOptions options) {
        this(null, options);
    }

    protected AbstractJDBCAction(JDBCStatementHelper helper, SQLOptions options) {
        this.options = options;
        this.helper = helper;
    }

    public abstract T execute(Connection var1) throws SQLException;

    protected void applyStatementOptions(Statement statement) throws SQLException {
        if (this.options != null) {
            if (this.options.getQueryTimeout() > 0) {
                statement.setQueryTimeout(this.options.getQueryTimeout());
            }
            if (this.options.getFetchDirection() != null) {
                statement.setFetchDirection(this.options.getFetchDirection().getType());
            }
            if (this.options.getFetchSize() > 0) {
                statement.setFetchSize(this.options.getFetchSize());
            }
        }
    }
}

