/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.actions.JDBCPrepareStatementAction;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedBatch;
import io.vertx.jdbcclient.impl.actions.JDBCPreparedQuery;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.jdbcclient.impl.actions.JDBCSimpleQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCTxOp;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;

public class ConnectionImpl
implements Connection {
    final JDBCStatementHelper helper;
    final ContextInternal context;
    final JDBCConnectionImpl conn;
    final SQLOptions sqlOptions;

    public ConnectionImpl(JDBCStatementHelper helper, ContextInternal context, SQLOptions sqlOptions, JDBCConnectionImpl conn) {
        this.conn = conn;
        this.helper = helper;
        this.context = context;
        this.sqlOptions = sqlOptions;
    }

    public boolean isSsl() {
        return false;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        throw new UnsupportedOperationException();
    }

    public void init(Connection.Holder holder) {
    }

    public void close(Connection.Holder holder, Promise<Void> promise) {
        this.conn.close((Handler<AsyncResult<Void>>)promise);
    }

    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    public <R> void schedule(CommandBase<R> commandBase, Promise<R> promise) {
        if (commandBase instanceof SimpleQueryCommand) {
            this.handle((SimpleQueryCommand)commandBase, promise);
        } else if (commandBase instanceof PrepareStatementCommand) {
            this.handle((PrepareStatementCommand)commandBase, promise);
        } else if (commandBase instanceof ExtendedQueryCommand) {
            this.handle((ExtendedQueryCommand)commandBase, promise);
        } else if (commandBase instanceof TxCommand) {
            this.handle((TxCommand)commandBase, promise);
        } else {
            promise.fail("Not yet implemented " + commandBase);
        }
    }

    private void handle(PrepareStatementCommand command, Promise<PreparedStatement> promise) {
        JDBCPrepareStatementAction action = new JDBCPrepareStatementAction(this.helper, this.sqlOptions, command.sql());
        Future<PreparedStatement> fut = this.conn.schedule(action);
        fut.onComplete(promise);
    }

    private <R> void handle(ExtendedQueryCommand<R> command, Promise<Boolean> promise) {
        JDBCQueryAction action = command.isBatch() ? new JDBCPreparedBatch(this.helper, this.sqlOptions, command, command.collector(), command.paramsList()) : new JDBCPreparedQuery(this.helper, this.sqlOptions, command, command.collector(), command.params());
        this.handle(action, command.resultHandler(), promise);
    }

    private <R> void handle(SimpleQueryCommand<R> command, Promise<Boolean> promise) {
        JDBCSimpleQueryAction action = new JDBCSimpleQueryAction(this.helper, this.sqlOptions, command.sql(), command.collector());
        this.handle(action, command.resultHandler(), promise);
    }

    private <R> void handle(TxCommand<R> command, Promise<R> promise) {
        JDBCTxOp<R> action = new JDBCTxOp<R>(this.helper, command, this.sqlOptions);
        Future<R> fut = this.conn.schedule(action);
        fut.onComplete(promise);
    }

    private <R> void handle(JDBCQueryAction<?, R> action, QueryResultHandler<R> handler, Promise<Boolean> promise) {
        Future fut = this.conn.schedule(action);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                ((JDBCResponse)ar.result()).handle(handler);
                promise.complete((Object)false);
            } else {
                promise.fail(ar.cause());
            }
        });
    }
}

