/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.sqlclient.PoolOptions;
import java.security.Principal;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Supplier;
import javax.sql.DataSource;

public class AgroalCPDataSourceProvider
implements DataSourceProvider {
    private final JDBCConnectOptions connectOptions;
    private final PoolOptions poolOptions;

    public AgroalCPDataSourceProvider(JDBCConnectOptions connectOptions, PoolOptions poolOptions) {
        this.connectOptions = connectOptions;
        this.poolOptions = poolOptions;
    }

    @Override
    public int maximumPoolSize(DataSource dataSource, JsonObject config) {
        return this.poolOptions.getMaxSize();
    }

    @Override
    public DataSource getDataSource(JsonObject config) throws SQLException {
        AgroalDataSourceConfigurationSupplier dataSourceConfigurationBuilder = new AgroalDataSourceConfigurationSupplier().dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.valueOf((String)this.connectOptions.getDataSourceImplementation())).metricsEnabled(this.connectOptions.isMetricsEnabled()).connectionPoolConfiguration(cp -> cp.validationTimeout(Duration.ofMillis(this.connectOptions.getConnectTimeout())).minSize(0).maxSize(this.poolOptions.getMaxSize()).initialSize(1).acquisitionTimeout(Duration.ofMillis(this.connectOptions.getConnectTimeout())).reapTimeout(Duration.ofMillis(this.connectOptions.getIdleTimeout())).leakTimeout(Duration.ofMillis(this.connectOptions.getIdleTimeout())).connectionFactoryConfiguration(cf -> cf.jdbcUrl(this.connectOptions.getJdbcUrl()).principal((Principal)(this.connectOptions.getUser() != null ? new NamePrincipal(this.connectOptions.getUser()) : null)).credential((Object)(this.connectOptions.getPassword() != null ? new SimplePassword(this.connectOptions.getPassword()) : null))));
        return AgroalDataSource.from((Supplier)dataSourceConfigurationBuilder, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
    }

    @Override
    public void close(DataSource dataSource) throws SQLException {
        if (dataSource instanceof AgroalDataSource) {
            ((AgroalDataSource)dataSource).close();
        }
    }
}

