/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.SqlOutParam;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collector;

public class JDBCPreparedBatch<C, R>
extends JDBCQueryAction<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final List<Tuple> listParams;

    public JDBCPreparedBatch(JDBCStatementHelper helper, SQLOptions options, ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, List<Tuple> listParams) {
        super(helper, options, collector);
        this.query = query;
        this.listParams = listParams;
    }

    @Override
    public JDBCResponse<R> execute(Connection conn) throws SQLException {
        boolean returnAutoGeneratedKeys = this.returnAutoGeneratedKeys(conn);
        try (PreparedStatement ps = this.prepare(conn, returnAutoGeneratedKeys);){
            for (Tuple params : this.listParams) {
                this.fillStatement(ps, conn, params);
                ps.addBatch();
            }
            JDBCResponse jDBCResponse = this.decode(ps, ps.executeBatch(), returnAutoGeneratedKeys);
            return jDBCResponse;
        }
    }

    private PreparedStatement prepare(Connection conn, boolean returnAutoGeneratedKeys) throws SQLException {
        boolean autoGeneratedIndexes;
        String sql = this.query.sql();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (returnAutoGeneratedKeys && !autoGeneratedIndexes) {
            return conn.prepareStatement(sql, 1);
        }
        if (autoGeneratedIndexes) {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            try {
                if (indexes.getValue(0) instanceof Number) {
                    int[] keys = new int[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getInteger(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                if (indexes.getValue(0) instanceof String) {
                    String[] keys = new String[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getString(i);
                    }
                    return conn.prepareStatement(sql, keys);
                }
                throw new SQLException("Invalid type of index, only [int, String] allowed");
            }
            catch (RuntimeException e) {
                throw new SQLException(e);
            }
        }
        return conn.prepareStatement(sql);
    }

    private void fillStatement(PreparedStatement ps, Connection conn, Tuple params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            Object value = this.adaptType(conn, params.getValue(i));
            if (value instanceof SqlOutParam) {
                throw new SQLException("{out} parameters are not supported in batch mode");
            }
            ps.setObject(i + 1, value);
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof Buffer) {
            Buffer blob = (Buffer)value;
            return conn.createBlob().setBytes(0L, blob.getBytes());
        }
        return value;
    }
}

