/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.jdbc.impl.JDBCClientImpl;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.JDBCConnectOptions;
import io.vertx.jdbcclient.impl.AgroalCPDataSourceProvider;
import io.vertx.jdbcclient.impl.JDBCPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import java.util.UUID;

@VertxGen
public interface JDBCPool
extends Pool {
    public static final PropertyKind<Row> GENERATED_KEYS = PropertyKind.create((String)"generated-keys", Row.class);
    public static final PropertyKind<Boolean> OUTPUT = PropertyKind.create((String)"callable-statement-output", Boolean.class);

    public static JDBCPool pool(Vertx vertx, JDBCConnectOptions connectOptions, PoolOptions poolOptions) {
        ContextInternal context = (ContextInternal)vertx.getOrCreateContext();
        return new JDBCPoolImpl(vertx, new JDBCClientImpl(vertx, new AgroalCPDataSourceProvider(connectOptions, poolOptions)), connectOptions, context.tracer() == null ? null : new QueryTracer(context.tracer(), connectOptions.getTracingPolicy(), connectOptions.getJdbcUrl(), connectOptions.getUser(), connectOptions.getDatabase()));
    }

    public static JDBCPool pool(Vertx vertx, JsonObject config) {
        ContextInternal context = (ContextInternal)vertx.getOrCreateContext();
        return new JDBCPoolImpl(vertx, new JDBCClientImpl(vertx, config, UUID.randomUUID().toString()), new SQLOptions(config), context.tracer() == null ? null : new QueryTracer(context.tracer(), TracingPolicy.PROPAGATE, config.getString("jdbcUrl"), config.getString("user"), config.getString("database")));
    }
}

