/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.ext.jdbc.impl.JDBCClientImpl;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.JDBCPool;
import io.vertx.jdbcclient.impl.ConnectionImpl;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class JDBCPoolImpl
extends SqlClientBase<JDBCPoolImpl>
implements JDBCPool {
    private final VertxInternal vertx;
    private final JDBCClientImpl client;
    private final SQLOptions sqlOptions;

    public JDBCPoolImpl(Vertx vertx, JDBCClientImpl client, SQLOptions sqlOptions, QueryTracer tracer) {
        super(tracer, null);
        this.vertx = (VertxInternal)vertx;
        this.client = client;
        this.sqlOptions = sqlOptions;
    }

    protected ContextInternal context() {
        return this.vertx.getOrCreateContext();
    }

    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        this.getConnection().onComplete(handler);
    }

    public Future<SqlConnection> getConnection() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return this.getConnectionInternal(ctx);
    }

    private Future<SqlConnection> getConnectionInternal(ContextInternal ctx) {
        return this.client.getConnection(ctx).map(c -> new SqlConnectionImpl(ctx, (Connection)new ConnectionImpl(this.client.getHelper(), ctx, this.sqlOptions, (JDBCConnectionImpl)c), this.tracer, null));
    }

    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.vertx.promise(handler);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.client.close(handler);
    }

    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.client.close((Promise<Void>)promise);
        return promise.future();
    }

    public <R> Future<R> schedule(ContextInternal contextInternal, CommandBase<R> commandBase) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return this.getConnectionInternal(ctx).flatMap(conn -> ((SqlConnectionImpl)conn).schedule(ctx, commandBase).flatMap(r -> conn.close().map(r)));
    }
}

