/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

public final class JDBCStatementHelper {
    private static final Logger log = LoggerFactory.getLogger(JDBCStatementHelper.class);
    private static final JsonArray EMPTY = new JsonArray(Collections.unmodifiableList(new ArrayList()));
    private static final Pattern DATETIME = Pattern.compile("^\\d{4}-(?:0[0-9]|1[0-2])-[0-9]{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d{3,9})?Z$");
    private static final Pattern DATE = Pattern.compile("^\\d{4}-(?:0[0-9]|1[0-2])-[0-9]{2}$");
    private static final Pattern TIME = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}$");
    private static final Pattern UUID = Pattern.compile("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
    private final boolean castUUID;
    private final boolean castDate;
    private final boolean castTime;
    private final boolean castDatetime;

    public JDBCStatementHelper() {
        this(new JsonObject());
    }

    public JDBCStatementHelper(JsonObject config) {
        this.castUUID = config.getBoolean("castUUID", Boolean.valueOf(false));
        this.castDate = config.getBoolean("castDate", Boolean.valueOf(true));
        this.castTime = config.getBoolean("castTime", Boolean.valueOf(true));
        this.castDatetime = config.getBoolean("castDatetime", Boolean.valueOf(true));
    }

    public void fillStatement(PreparedStatement statement, JsonArray in) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        for (int i = 0; i < in.size(); ++i) {
            Object value = in.getValue(i);
            if (value != null) {
                if (value instanceof String) {
                    statement.setObject(i + 1, this.optimisticCast((String)value));
                    continue;
                }
                statement.setObject(i + 1, value);
                continue;
            }
            statement.setObject(i + 1, null);
        }
    }

    public void fillStatement(CallableStatement statement, JsonArray in, JsonArray out) throws SQLException {
        if (in == null) {
            in = EMPTY;
        }
        if (out == null) {
            out = EMPTY;
        }
        int max = Math.max(in.size(), out.size());
        for (int i = 0; i < max; ++i) {
            Object value = null;
            boolean set = false;
            if (i < in.size()) {
                value = in.getValue(i);
            }
            if (value != null) {
                if (value instanceof String) {
                    statement.setObject(i + 1, this.optimisticCast((String)value));
                } else {
                    statement.setObject(i + 1, value);
                }
                set = true;
            }
            value = null;
            if (i < out.size()) {
                value = out.getValue(i);
            }
            if (value != null) {
                if (value instanceof String) {
                    statement.registerOutParameter(i + 1, (int)JDBCType.valueOf((String)value).getVendorTypeNumber());
                } else if (value instanceof Number) {
                    statement.registerOutParameter(i + 1, ((Number)value).intValue());
                }
                set = true;
            }
            if (set) continue;
            statement.setNull(i + 1, 0);
        }
    }

    public ResultSet asList(java.sql.ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        ArrayList<JsonArray> results = new ArrayList<JsonArray>();
        while (rs.next()) {
            JsonArray result = new JsonArray();
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCStatementHelper.convertSqlValue(rs.getObject(i));
                if (res != null) {
                    result.add(res);
                    continue;
                }
                result.addNull();
            }
            results.add(result);
        }
        return new ResultSet(columnNames, results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertSqlValue(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_TIME);
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        if (value instanceof Timestamp) {
            return OffsetDateTime.ofInstant(((Timestamp)value).toInstant(), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String string = c.getSubString(1L, (int)c.length());
                return string;
            }
            finally {
                try {
                    c.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] byArray = b.getBytes(1L, (int)b.length());
                return byArray;
            }
            finally {
                try {
                    b.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array a = (java.sql.Array)value;
            try {
                Object arr = a.getArray();
                if (arr != null) {
                    int len = Array.getLength(arr);
                    JsonArray jsonArray = new JsonArray();
                    for (int i = 0; i < len; ++i) {
                        jsonArray.add(JDBCStatementHelper.convertSqlValue(Array.get(arr, i)));
                    }
                    JsonArray jsonArray2 = jsonArray;
                    return jsonArray2;
                }
            }
            finally {
                a.free();
            }
        }
        return value.toString();
    }

    public Object optimisticCast(String value) {
        if (value == null) {
            return null;
        }
        try {
            if (this.castTime && TIME.matcher(value).matches()) {
                Instant instant = LocalTime.parse(value).atDate(LocalDate.of(1970, 1, 1)).toInstant(ZoneOffset.UTC);
                int offset = TimeZone.getDefault().getOffset(instant.toEpochMilli());
                return new Time(instant.toEpochMilli() - (long)offset);
            }
            if (this.castDate && DATE.matcher(value).matches()) {
                Instant instant = LocalDate.parse(value).atTime(LocalTime.of(0, 0, 0, 0)).toInstant(ZoneOffset.UTC);
                int offset = TimeZone.getDefault().getOffset(instant.toEpochMilli());
                return new Date(instant.toEpochMilli() - (long)offset);
            }
            if (this.castDatetime && DATETIME.matcher(value).matches()) {
                Instant instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(value));
                return Timestamp.from(instant);
            }
            if (this.castUUID && UUID.matcher(value).matches()) {
                return java.util.UUID.fromString(value);
            }
        }
        catch (RuntimeException e) {
            log.debug((Object)e);
        }
        return value;
    }
}

