/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.JDBCRow;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class JDBCQueryAction<C, R>
extends AbstractJDBCAction<JDBCResponse<R>> {
    private final Collector<Row, C, R> collector;

    public JDBCQueryAction(JDBCStatementHelper helper, SQLOptions options, Collector<Row, C, R> collector) {
        super(helper, options);
        this.collector = collector;
    }

    protected JDBCResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys, List<Integer> out) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                }
                if (returnedKeys) {
                    this.decodeReturnedKeys(statement, response);
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
            if (returnedKeys) {
                this.decodeReturnedKeys(statement, response);
            }
        }
        if (out.size() > 0) {
            this.decodeOutput((CallableStatement)statement, out, response);
        }
        return response;
    }

    protected JDBCResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        JDBCResponse<R> response = new JDBCResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        RowDesc desc = new RowDesc(Collections.emptyList());
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            JDBCRow row = new JDBCRow(desc);
            row.addValue(result);
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedBatchResult.length != 0 && returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, JDBCResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        int size = 0;
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            ++size;
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCQueryAction.convertSqlValue(rs, i);
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private R decodeRawResultSet(ResultSet rs) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            JDBCRow row = new JDBCRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = JDBCQueryAction.convertSqlValue(rs, i);
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        return this.collector.finisher().apply(container);
    }

    private void decodeOutput(CallableStatement cs, List<Integer> out, JDBCResponse<R> output) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        JDBCRow row = new JDBCRow(new RowDesc(Collections.emptyList()));
        for (Integer idx : out) {
            Object o = cs.getObject(idx);
            if (o instanceof ResultSet) {
                row.addValue(this.decodeRawResultSet((ResultSet)o));
                continue;
            }
            Object res = JDBCQueryAction.convertSqlValue(o);
            row.addValue(res);
        }
        accumulator.accept(container, row);
        R result = this.collector.finisher().apply(container);
        output.outputs(result, null, 1);
    }

    private void decodeReturnedKeys(Statement statement, JDBCResponse<R> response) throws SQLException {
        ResultSetMetaData metaData;
        JDBCRow keys = null;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null && keysRS.next() && (metaData = keysRS.getMetaData()) != null) {
            int cols = metaData.getColumnCount();
            if (cols > 0) {
                int i;
                ArrayList<String> keysColumnNames = new ArrayList<String>();
                RowDesc keysDesc = new RowDesc(keysColumnNames);
                for (i = 1; i <= cols; ++i) {
                    keysColumnNames.add(metaData.getColumnLabel(i));
                }
                keys = new JDBCRow(keysDesc);
                for (i = 1; i <= cols; ++i) {
                    Object res = JDBCQueryAction.convertSqlValue(keysRS, i);
                    keys.addValue(res);
                }
            }
            response.returnedKeys(keys);
        }
    }

    private static Object convertSqlValue(Object o) throws SQLException {
        try {
            return JDBCQueryAction.convertSqlValue(null, -1, o);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static Object convertSqlValue(ResultSet rs, int pos) throws SQLException {
        try {
            return JDBCQueryAction.convertSqlValue(rs, pos, rs.getObject(pos));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convertSqlValue(ResultSet rs, int pos, Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toInstant().atOffset(ZoneOffset.UTC);
        }
        if (value instanceof Clob) {
            if (rs != null) {
                return rs.getString(pos);
            }
            Clob c = (Clob)value;
            return JDBCQueryAction.getString(c);
        }
        if (value instanceof Blob) {
            if (rs != null) {
                return Buffer.buffer((byte[])rs.getBytes(pos));
            }
            Blob b = (Blob)value;
            return JDBCQueryAction.getBinary(b);
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array a = (java.sql.Array)value;
            try {
                Object arr = a.getArray();
                if (arr != null) {
                    int len = Array.getLength(arr);
                    Object[] castedArray = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        castedArray[i] = JDBCQueryAction.convertSqlValue(Array.get(arr, i));
                    }
                    Object[] objectArray = castedArray;
                    return objectArray;
                }
            }
            finally {
                a.free();
            }
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        return value.toString();
    }

    boolean returnAutoGeneratedKeys(Connection conn) {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null && this.options.getAutoGeneratedKeysIndexes().size() > 0;
        if (autoGeneratedKeys || autoGeneratedIndexes) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd != null) {
                    return dbmd.supportsGetGeneratedKeys();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getString(Clob data) throws SQLException {
        if (data == null) {
            return null;
        }
        if (data.length() == 0L) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        char[] buf = new char[1024];
        try (Reader in = data.getCharacterStream();){
            int l;
            while ((l = in.read(buf)) > -1) {
                buffer.append(buf, 0, l);
            }
        }
        catch (IOException ioe) {
            throw new SQLException("Unable to read character stream from Clob.", ioe);
        }
        return buffer.toString();
    }

    private static Buffer getBinary(Blob data) throws SQLException {
        if (data == null) {
            return null;
        }
        if (data.length() == 0L) {
            return Buffer.buffer((int)0);
        }
        Buffer buffer = Buffer.buffer((int)1024);
        byte[] buf = new byte[1024];
        try (InputStream in = data.getBinaryStream();){
            int l;
            while ((l = in.read(buf)) > -1) {
                buffer.appendBytes(buf, 0, l);
            }
        }
        catch (IOException ioe) {
            throw new SQLException("Unable to read binary stream from Blob.", ioe);
        }
        return buffer;
    }
}

