/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.impl.DataSourceHolder;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.jdbc.impl.actions.JDBCQuery;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.jdbc.impl.actions.JDBCUpdate;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class JDBCClientImpl
implements JDBCClient,
Closeable {
    private static final String DS_LOCAL_MAP_NAME = "__vertx.JDBCClient.datasources";
    private final VertxInternal vertx;
    private final String datasourceName;
    private final JsonObject config;
    private final Map<String, DataSourceHolder> holders;
    private final JDBCStatementHelper helper;
    private boolean closed;

    public JDBCClientImpl(Vertx vertx, DataSource dataSource) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(dataSource);
        this.vertx = (VertxInternal)vertx;
        this.datasourceName = UUID.randomUUID().toString();
        this.config = null;
        this.holders = vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
        DataSourceHolder holder = new DataSourceHolder(dataSource, this.createExecutor(), this.createMetrics(this.datasourceName, -1));
        this.holders.put(this.datasourceName, holder);
        this.helper = new JDBCStatementHelper();
        this.setupCloseHook();
    }

    public JDBCClientImpl(Vertx vertx, JsonObject config, String datasourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(datasourceName);
        this.vertx = (VertxInternal)vertx;
        this.datasourceName = datasourceName;
        this.config = config;
        this.holders = vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
        DataSourceProvider provider = DataSourceProvider.create(config);
        this.holders.compute(datasourceName, (k, h) -> h == null ? new DataSourceHolder(provider) : h.increment());
        this.helper = new JDBCStatementHelper(config);
        this.setupCloseHook();
    }

    public JDBCClientImpl(Vertx vertx, DataSourceProvider dataSourceProvider) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(dataSourceProvider);
        this.vertx = (VertxInternal)vertx;
        this.datasourceName = UUID.randomUUID().toString();
        this.config = new JsonObject();
        this.holders = vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
        this.holders.compute(this.datasourceName, (k, h) -> h == null ? new DataSourceHolder(dataSourceProvider) : h.increment());
        this.helper = new JDBCStatementHelper(dataSourceProvider.getInitialConfig());
        this.setupCloseHook();
    }

    private void setupCloseHook() {
        ContextInternal ctx = this.vertx.getContext();
        if (ctx != null) {
            ctx.addCloseHook((Closeable)this);
        }
    }

    public JDBCStatementHelper getHelper() {
        return this.helper;
    }

    public void close(Promise<Void> completion) {
        this.close((Handler<AsyncResult<Void>>)completion);
    }

    @Override
    public void close() {
        this.close((Promise<Void>)null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.raiseCloseFlag()) {
            while (true) {
                DataSourceHolder current = this.holders.get(this.datasourceName);
                DataSourceHolder next = current.decrement();
                if (next.refCount == 0) {
                    if (!this.holders.remove(this.datasourceName, current)) continue;
                    if (current.dataSource != null) {
                        this.doClose(current, completionHandler);
                        return;
                    }
                    break;
                }
                if (this.holders.replace(this.datasourceName, current, next)) break;
            }
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
        } else if (completionHandler != null) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    private synchronized boolean raiseCloseFlag() {
        if (!this.closed) {
            this.closed = true;
            return true;
        }
        return false;
    }

    @Override
    public JDBCClient update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.executeDirect(new JDBCUpdate(this.helper, null, sql, null), resultHandler);
        return this;
    }

    @Override
    public JDBCClient updateWithParams(String sql, JsonArray in, Handler<AsyncResult<UpdateResult>> resultHandler) {
        this.executeDirect(new JDBCUpdate(this.helper, null, sql, in), resultHandler);
        return this;
    }

    @Override
    public JDBCClient query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.executeDirect(new JDBCQuery(this.helper, null, sql, null), resultHandler);
        return this;
    }

    @Override
    public JDBCClient queryWithParams(String sql, JsonArray in, Handler<AsyncResult<ResultSet>> resultHandler) {
        this.executeDirect(new JDBCQuery(this.helper, null, sql, in), resultHandler);
        return this;
    }

    private <T> void executeDirect(AbstractJDBCAction<T> action, Handler<AsyncResult<T>> handler) {
        this.getConnection().flatMap(sqlConnection -> {
            JDBCConnectionImpl conn = (JDBCConnectionImpl)sqlConnection;
            return conn.schedule(action).onComplete(v -> conn.close());
        }).onComplete(handler);
    }

    public Future<SQLConnection> getConnection() {
        return this.getConnection(this.vertx.getOrCreateContext());
    }

    public Future<SQLConnection> getConnection(ContextInternal ctx) {
        return this.getDataSourceHolder(ctx).flatMap(holder -> {
            PromiseInternal res = ctx.promise();
            boolean enabled = holder.metrics != null;
            Object queueMetric = enabled ? holder.metrics.submitted() : null;
            holder.exec.execute(() -> this.lambda$null$4(holder, enabled, queueMetric, (Promise)res, ctx));
            return res.future();
        });
    }

    private synchronized Future<DataSourceHolder> getDataSourceHolder(ContextInternal ctx) {
        if (this.closed) {
            return ctx.failedFuture("Client is closed");
        }
        DataSourceHolder holder = this.holders.get(this.datasourceName);
        if (holder.dataSource != null) {
            return ctx.succeededFuture((Object)holder);
        }
        return ctx.executeBlocking(promise -> this.createDataSource((Promise<DataSourceHolder>)promise), holder.creationQueue);
    }

    private void createDataSource(Promise<DataSourceHolder> promise) {
        int poolSize;
        DataSource dataSource;
        DataSourceHolder current = this.holders.get(this.datasourceName);
        if (current == null) {
            promise.fail("Client closed while connecting");
            return;
        }
        if (current.dataSource != null) {
            promise.complete((Object)current);
            return;
        }
        DataSourceProvider provider = current.provider;
        try {
            dataSource = provider.getDataSource(this.config);
            poolSize = provider.maximumPoolSize(dataSource, this.config);
        }
        catch (SQLException e) {
            promise.fail((Throwable)e);
            return;
        }
        ExecutorService exec = this.createExecutor();
        PoolMetrics metrics = this.createMetrics(this.datasourceName, poolSize);
        current = this.holders.compute(this.datasourceName, (k, h) -> h == null ? null : h.created(dataSource, exec, metrics));
        if (current != null) {
            promise.complete((Object)current);
        } else {
            if (metrics != null) {
                metrics.close();
            }
            exec.shutdown();
            try {
                provider.close(dataSource);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            promise.fail("Client closed while connecting");
        }
    }

    @Override
    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.getConnection().onComplete(handler);
        return this;
    }

    private PoolMetrics createMetrics(String poolName, int maxPoolSize) {
        VertxMetrics metricsSPI = this.vertx.metricsSPI();
        return metricsSPI != null ? metricsSPI.createPoolMetrics("datasource", poolName, maxPoolSize) : null;
    }

    private ExecutorService createExecutor() {
        return new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "vertx-jdbc-service-get-connection-thread"));
    }

    private void doClose(DataSourceHolder holder, Handler<AsyncResult<Void>> completionHandler) {
        if (holder.metrics != null) {
            holder.metrics.close();
        }
        this.vertx.executeBlocking(promise -> {
            try {
                if (holder.provider != null) {
                    holder.provider.close(holder.dataSource);
                }
                promise.complete();
            }
            catch (SQLException e) {
                promise.fail((Throwable)e);
            }
        }, false, ar -> {
            holder.exec.shutdown();
            if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
        });
    }

    private /* synthetic */ void lambda$null$4(DataSourceHolder holder, boolean enabled, Object queueMetric, Promise res, ContextInternal ctx) {
        try {
            Connection conn = holder.dataSource.getConnection();
            Object execMetric = enabled ? holder.metrics.begin(queueMetric) : null;
            res.complete((Object)new JDBCConnectionImpl((Context)ctx, this.helper, conn, holder.metrics, execMetric));
        }
        catch (SQLException e) {
            if (enabled) {
                holder.metrics.rejected(queueMetric);
            }
            res.fail((Throwable)e);
        }
    }
}

