/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.ServiceHelper;
import io.vertx.core.cli.impl.ReflectionUtils;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.JDBCDecoder;
import io.vertx.ext.jdbc.spi.JDBCEncoder;
import io.vertx.ext.jdbc.spi.impl.JDBCDecoderImpl;
import io.vertx.ext.jdbc.spi.impl.JDBCEncoderImpl;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class JDBCStatementHelper {
    public static final Function<JDBCType, Class> LOOKUP_SQL_NUMBER = jdbcType -> {
        switch (jdbcType) {
            case TINYINT: {
                return Byte.TYPE;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case FLOAT: 
            case REAL: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case NUMERIC: 
            case DECIMAL: {
                return BigDecimal.class;
            }
        }
        throw new IllegalArgumentException("Invalid Number JDBC Type");
    };
    public static final Function<JDBCType, Class> LOOKUP_SQL_DATETIME = jdbcType -> {
        switch (jdbcType) {
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case TIMESTAMP: {
                return LocalDateTime.class;
            }
            case TIME_WITH_TIMEZONE: {
                return OffsetTime.class;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return OffsetDateTime.class;
            }
        }
        throw new IllegalArgumentException("Invalid Date Time JDBC Type");
    };
    public static final Pattern UUID = Pattern.compile("^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
    private final JDBCEncoder encoder;
    private final JDBCDecoder decoder;

    public JDBCStatementHelper() {
        this(new JsonObject());
    }

    public JDBCStatementHelper(JsonObject config) {
        this.encoder = this.initEncoder(config);
        this.decoder = this.initDecoder(config);
    }

    private JDBCEncoder initEncoder(JsonObject config) {
        JDBCEncoder encoder = (JDBCEncoder)JDBCStatementHelper.initObject(config.getString("encoderCls"));
        if (encoder == null) {
            encoder = Optional.ofNullable(ServiceHelper.loadFactoryOrNull(JDBCEncoder.class)).orElseGet(JDBCEncoderImpl::new);
        }
        return encoder;
    }

    private JDBCDecoder initDecoder(JsonObject config) {
        JDBCDecoder decoder = (JDBCDecoder)JDBCStatementHelper.initObject(config.getString("decoderCls"));
        if (decoder == null) {
            return Optional.ofNullable(ServiceHelper.loadFactoryOrNull(JDBCDecoder.class)).orElseGet(JDBCDecoderImpl::new);
        }
        return decoder;
    }

    public JDBCEncoder getEncoder() {
        return this.encoder;
    }

    public JDBCDecoder getDecoder() {
        return this.decoder;
    }

    private static <T> T initObject(String clsName) {
        Class<T> cls = JDBCStatementHelper.findClass(clsName);
        return (T)(cls == null ? null : ReflectionUtils.newInstance(cls));
    }

    private static <T> Class<T> findClass(String cls) {
        if (Objects.isNull(cls)) {
            return null;
        }
        for (ClassLoader classLoader : Arrays.asList(Thread.currentThread().getContextClassLoader(), JDBCStatementHelper.class.getClassLoader())) {
            try {
                return Class.forName(cls, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        return null;
    }
}

