/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

@FunctionalInterface
public interface JDBCTypeProvider {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCTypeProvider.class);

    public static JDBCTypeProvider fromParameter(PreparedStatement statement) {
        return col -> {
            try {
                return JDBCType.valueOf(statement.getParameterMetaData().getParameterType(col));
            }
            catch (SQLFeatureNotSupportedException e) {
                LOG.warn((Object)("ParameterMetadata is unsupported by" + statement.getClass().getName()), (Throwable)e);
                return JDBCType.OTHER;
            }
        };
    }

    public static JDBCTypeProvider fromResult(ResultSet rs) {
        return col -> {
            try {
                return JDBCType.valueOf(rs.getMetaData().getColumnType(col));
            }
            catch (SQLFeatureNotSupportedException e) {
                LOG.warn((Object)("ResultSetMetadata is unsupported by" + rs.getClass().getName()), (Throwable)e);
                return JDBCType.OTHER;
            }
        };
    }

    public JDBCType apply(int var1) throws SQLException;
}

